/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.pulsar;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="pulsar")
@Dependent
public class PulsarChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.pulsar.";
    private static final String PROP_CLIENT_PREFIX = "debezium.sink.pulsar.client.";
    private static final String PROP_PRODUCER_PREFIX = "debezium.sink.pulsar.producer.";
    private final Map<String, Producer<?>> producers = new HashMap();
    private PulsarClient pulsarClient;
    private Map<String, Object> producerConfig;
    @ConfigProperty(name="debezium.sink.pulsar.null.key", defaultValue="default")
    String nullKey;
    @ConfigProperty(name="debezium.sink.pulsar.tenant", defaultValue="public")
    String pulsarTenant;
    @ConfigProperty(name="debezium.sink.pulsar.namespace", defaultValue="default")
    String pulsarNamespace;

    @PostConstruct
    void connect() {
        Config config = ConfigProvider.getConfig();
        try {
            this.pulsarClient = PulsarClient.builder().loadConf(this.getConfigSubset(config, PROP_CLIENT_PREFIX)).build();
        }
        catch (PulsarClientException e) {
            throw new DebeziumException((Throwable)e);
        }
        this.producerConfig = this.getConfigSubset(config, PROP_PRODUCER_PREFIX);
    }

    @PreDestroy
    void close() {
        this.producers.values().forEach(producer -> {
            try {
                producer.close();
            }
            catch (Exception e) {
                LOGGER.warn("Exception while closing producer: {}", (Throwable)e);
            }
        });
        try {
            this.pulsarClient.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception while closing client: {}", (Throwable)e);
        }
    }

    private Producer<?> createProducer(String topicName, Object value) {
        String topicFullName = this.pulsarTenant + "/" + this.pulsarNamespace + "/" + topicName;
        try {
            if (value instanceof String) {
                return this.pulsarClient.newProducer(Schema.STRING).loadConf(this.producerConfig).topic(topicFullName).create();
            }
            return this.pulsarClient.newProducer().loadConf(this.producerConfig).topic(topicFullName).create();
        }
        catch (PulsarClientException e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> record : records) {
            LOGGER.trace("Received event '{}'", record);
            String topicName = this.streamNameMapper.map(record.destination());
            Producer producer = this.producers.computeIfAbsent(topicName, topic -> this.createProducer((String)topic, record.value()));
            String key = record.key() == null ? this.nullKey : this.getString(record.key());
            TypedMessageBuilder message = record.value() instanceof String ? producer.newMessage(Schema.STRING) : producer.newMessage();
            message.properties(this.convertHeaders(record)).key(key).value(record.value());
            try {
                MessageId messageId = message.send();
                LOGGER.trace("Sent message with id: {}", (Object)messageId);
            }
            catch (PulsarClientException e) {
                throw new DebeziumException((Throwable)e);
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    public static interface ProducerBuilder {
        public Producer<Object> get(String var1, Object var2);
    }
}

