/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.pulsar;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class PulsarTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final String PULSAR_VERSION = "2.5.2";
    public static final int PULSAR_PORT = 6650;
    public static final int PULSAR_HTTP_PORT = 8080;
    public static final String PULSAR_IMAGE = "apachepulsar/pulsar:2.5.2";
    private static final GenericContainer<?> container = new GenericContainer("apachepulsar/pulsar:2.5.2").withStartupTimeout(Duration.ofSeconds(90L)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*messaging service is ready.*", (int)1)).withCommand(new String[]{"bin/pulsar", "standalone"}).withClasspathResourceMapping("/docker/conf/", "/pulsar/conf", BindMode.READ_ONLY).withExposedPorts(new Integer[]{6650, 8080});

    public Map<String, String> start() {
        container.start();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.sink.pulsar.client.serviceUrl", PulsarTestResourceLifecycleManager.getPulsarServiceUrl());
        return params;
    }

    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPulsarServiceUrl() {
        return "pulsar://localhost:" + container.getMappedPort(6650);
    }
}

