/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.pulsar;

import io.debezium.server.TestConfigSource;
import io.debezium.server.TestDatabase;
import java.util.HashMap;
import java.util.Map;

public class PulsarTestConfigSource
extends TestConfigSource {
    final Map<String, String> pulsarTest = new HashMap<String, String>();

    public PulsarTestConfigSource() {
        this.pulsarTest.put("debezium.sink.type", "pulsar");
        this.pulsarTest.put("debezium.sink.pulsar.client.serviceUrl", PulsarTestConfigSource.getServiceUrl());
        this.pulsarTest.put("debezium.source.connector.class", "io.debezium.connector.postgresql.PostgresConnector");
        this.pulsarTest.put("debezium.source.offset.storage.file.filename", OFFSET_STORE_PATH.toAbsolutePath().toString());
        this.pulsarTest.put("debezium.source.offset.flush.interval.ms", "0");
        this.pulsarTest.put("debezium.source.database.hostname", "localhost");
        this.pulsarTest.put("debezium.source.database.port", Integer.toString(TestDatabase.POSTGRES_PORT));
        this.pulsarTest.put("debezium.source.database.user", "postgres");
        this.pulsarTest.put("debezium.source.database.password", "postgres");
        this.pulsarTest.put("debezium.source.database.dbname", "postgres");
        this.pulsarTest.put("debezium.source.database.server.name", "testc");
        this.pulsarTest.put("debezium.source.schema.whitelist", "inventory");
        this.pulsarTest.put("debezium.source.table.whitelist", "inventory.customers");
        this.config = this.pulsarTest;
    }

    public static String getServiceUrl() {
        return "pulsar://localhost:" + System.getProperty("pulsar.port.native", "6650");
    }
}

