/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.pubsub;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="pubsub")
@Dependent
public class PubSubChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PubSubChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.pubsub.";
    private static final String PROP_PROJECT_ID = "debezium.sink.pubsub.project.id";
    private String projectId;
    private final Map<String, Publisher> publishers = new HashMap<String, Publisher>();
    private PublisherBuilder publisherBuilder;
    @ConfigProperty(name="debezium.sink.pubsub.ordering.enabled", defaultValue="true")
    boolean orderingEnabled;
    @ConfigProperty(name="debezium.sink.pubsub.null.key", defaultValue="default")
    String nullKey;
    @Inject
    @CustomConsumerBuilder
    Instance<PublisherBuilder> customPublisherBuilder;

    @PostConstruct
    void connect() {
        Config config = ConfigProvider.getConfig();
        this.projectId = config.getOptionalValue(PROP_PROJECT_ID, String.class).orElse(ServiceOptions.getDefaultProjectId());
        if (this.customPublisherBuilder.isResolvable()) {
            this.publisherBuilder = (PublisherBuilder)this.customPublisherBuilder.get();
            LOGGER.info("Obtained custom configured PublisherBuilder '{}'", this.customPublisherBuilder);
            return;
        }
        this.publisherBuilder = t -> {
            try {
                return Publisher.newBuilder((TopicName)t).setEnableMessageOrdering(this.orderingEnabled).build();
            }
            catch (IOException e) {
                throw new DebeziumException((Throwable)e);
            }
        };
        LOGGER.info("Using default PublisherBuilder '{}'", (Object)this.publisherBuilder);
    }

    @PreDestroy
    void close() {
        this.publishers.values().forEach(publisher -> {
            try {
                publisher.shutdown();
            }
            catch (Exception e) {
                LOGGER.warn("Exception while closing publisher: {}", (Throwable)e);
            }
        });
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        List messageIds;
        ArrayList<ApiFuture> deliveries = new ArrayList<ApiFuture>();
        for (ChangeEvent<Object, Object> record : records) {
            LOGGER.trace("Received event '{}'", record);
            String topicName = this.streamNameMapper.map(record.destination());
            Publisher publisher = this.publishers.computeIfAbsent(topicName, x -> this.publisherBuilder.get(ProjectTopicName.of((String)this.projectId, (String)x)));
            PubsubMessage.Builder pubsubMessage = PubsubMessage.newBuilder();
            if (this.orderingEnabled) {
                if (record.key() == null) {
                    pubsubMessage.setOrderingKey(this.nullKey);
                } else if (record.key() instanceof String) {
                    pubsubMessage.setOrderingKey((String)record.key());
                } else if (record.key() instanceof byte[]) {
                    pubsubMessage.setOrderingKeyBytes(ByteString.copyFrom((byte[])((byte[])record.key())));
                }
            }
            if (record.value() instanceof String) {
                pubsubMessage.setData(ByteString.copyFromUtf8((String)((String)record.value())));
            } else if (record.value() instanceof byte[]) {
                pubsubMessage.setData(ByteString.copyFrom((byte[])((byte[])record.value())));
            }
            deliveries.add(publisher.publish(pubsubMessage.build()));
            committer.markProcessed(record);
        }
        try {
            messageIds = (List)ApiFutures.allAsList(deliveries).get();
        }
        catch (ExecutionException e) {
            throw new DebeziumException((Throwable)e);
        }
        LOGGER.trace("Sent messages with ids: {}", (Object)messageIds);
        committer.markBatchFinished();
    }

    public boolean supportsTombstoneEvents() {
        return false;
    }

    public static interface PublisherBuilder {
        public Publisher get(ProjectTopicName var1);
    }
}

