/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.nats.streaming;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class NatsStreamingTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final int NATS_STREAMING_PORT = 4222;
    public static final String NATS_STREAMING_IMAGE = "nats-streaming:latest";
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final GenericContainer<?> container = new GenericContainer("nats-streaming:latest").withExposedPorts(new Integer[]{4222}).withCommand(new String[]{"-SD", "-cid", "debezium"}).waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Server is ready.*"));

    private static synchronized void start(boolean ignored) {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public Map<String, String> start() {
        NatsStreamingTestResourceLifecycleManager.start(true);
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        return params;
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }

    public static String getNatsStreamingContainerUrl() {
        NatsStreamingTestResourceLifecycleManager.start(true);
        return String.format("nats://%s:%d", container.getContainerIpAddress(), container.getFirstMappedPort());
    }
}

