/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.nats.streaming;

import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.events.ConnectorStartedEvent;
import io.debezium.server.nats.streaming.NatsStreamingTestConfigSource;
import io.debezium.server.nats.streaming.NatsStreamingTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.nats.streaming.Message;
import io.nats.streaming.MessageHandler;
import io.nats.streaming.NatsStreaming;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.Subscription;
import io.nats.streaming.SubscriptionOptions;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Observes;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class), @QuarkusTestResource(value=NatsStreamingTestResourceLifecycleManager.class)})
public class NatsStreamingIT {
    private static final int MESSAGE_COUNT = 4;
    private static final String SUBJECT_NAME = "testc.inventory.customers";
    private static final String CLUSTER_ID = "debezium";
    private static final String CLIENT_ID = "debezium-test";
    protected static StreamingConnection sc;
    protected static Subscription subscription;
    private static final List<Message> messages;

    void setupDependencies(@Observes ConnectorStartedEvent event) {
        Testing.Print.enable();
        Options stanOptions = new Options.Builder().natsUrl(NatsStreamingTestResourceLifecycleManager.getNatsStreamingContainerUrl()).build();
        try {
            sc = NatsStreaming.connect((String)CLUSTER_ID, (String)CLIENT_ID, (Options)stanOptions);
        }
        catch (Exception e) {
            Testing.print((Object)"Could not connect to NATS Streaming");
        }
        try {
            subscription = sc.subscribe(SUBJECT_NAME, new MessageHandler(){

                public void onMessage(Message m) {
                    messages.add(m);
                }
            }, new SubscriptionOptions.Builder().deliverAllAvailable().build());
        }
        catch (Exception e) {
            Testing.print((Object)"Could not register message handler");
        }
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            throw (Exception)event.getError().get();
        }
    }

    @AfterAll
    static void stop() throws Exception {
        if (subscription != null) {
            subscription.unsubscribe();
        }
        sc.close();
    }

    @Test
    public void testNatsStreaming() {
        Awaitility.await().atMost(Duration.ofSeconds(NatsStreamingTestConfigSource.waitForSeconds())).until(() -> messages.size() >= 4);
        Assertions.assertThat((int)messages.size()).isGreaterThanOrEqualTo(4);
    }

    static {
        Testing.Files.delete((Path)NatsStreamingTestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)NatsStreamingTestConfigSource.OFFSET_STORE_PATH);
        messages = Collections.synchronizedList(new ArrayList());
    }
}

