/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.nats.jetstream;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class NatsJetStreamTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final int NATS_PORT = 4222;
    public static final String NATS_IMAGE = "nats:latest";
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final GenericContainer<?> container = new GenericContainer("nats:latest").withExposedPorts(new Integer[]{4222}).withCommand("-js").waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Server is ready.*"));

    private static synchronized void start(boolean ignored) {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public Map<String, String> start() {
        NatsJetStreamTestResourceLifecycleManager.start(true);
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        return params;
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }

    public static String getNatsContainerUrl() {
        NatsJetStreamTestResourceLifecycleManager.start(true);
        return String.format("nats://%s:%d", container.getHost(), container.getFirstMappedPort());
    }
}

