/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.nats.jetstream;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="nats-jetstream")
@Dependent
public class NatsJetStreamChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NatsJetStreamChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.nats-jetstream.";
    private static final String PROP_URL = "debezium.sink.nats-jetstream.url";
    private static final String PROP_CREATE_STREAM = "debezium.sink.nats-jetstream.create-stream";
    private static final String PROP_SUBJECTS = "debezium.sink.nats-jetstream.subjects";
    private static final String PROP_STORAGE = "debezium.sink.nats-jetstream.storage";
    private Connection nc;
    private JetStream js;
    @ConfigProperty(name="debezium.sink.nats-jetstream.create-stream", defaultValue="false")
    boolean createStream;
    @Inject
    @CustomConsumerBuilder
    Instance<JetStream> customStreamingConnection;

    @PostConstruct
    void connect() {
        Config config = ConfigProvider.getConfig();
        String url = (String)config.getValue(PROP_URL, String.class);
        if (this.customStreamingConnection.isResolvable()) {
            this.js = (JetStream)this.customStreamingConnection.get();
            LOGGER.info("Obtained custom configured JetStream '{}'", (Object)this.js);
            return;
        }
        try {
            Options natsOptions = new Options.Builder().servers(url.split(",")).noReconnect().build();
            this.nc = Nats.connect((Options)natsOptions);
            if (this.createStream) {
                String subjects = config.getOptionalValue(PROP_SUBJECTS, String.class).orElse("*.*.*");
                String storage = config.getOptionalValue(PROP_STORAGE, String.class).orElse("memory");
                StorageType storageType = storage.equals("file") ? StorageType.File : StorageType.Memory;
                StreamConfiguration streamConfig = StreamConfiguration.builder().name("DebeziumStream").description("The debezium stream, contains messages which are coming from debezium").subjects(subjects.split(",")).storageType(storageType).build();
                LOGGER.info("Creating stream with config: {}", (Object)streamConfig);
                JetStreamManagement jsm = this.nc.jetStreamManagement();
                jsm.addStream(streamConfig);
            }
            this.js = this.nc.jetStream();
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    @PreDestroy
    void close() {
        try {
            if (this.nc != null) {
                this.nc.close();
                LOGGER.info("NATS connection closed.");
            }
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> rec : records) {
            if (rec.value() != null) {
                String subject = this.streamNameMapper.map(rec.destination());
                byte[] recordBytes = this.getBytes(rec.value());
                LOGGER.trace("Received event @ {} = '{}'", (Object)subject, (Object)this.getString(rec.value()));
                try {
                    this.js.publish(subject, recordBytes);
                }
                catch (Exception e) {
                    throw new DebeziumException((Throwable)e);
                }
            }
            committer.markProcessed(rec);
        }
        committer.markBatchFinished();
    }
}

