/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.kinesis;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;

@Named(value="kinesis")
@Dependent
public class KinesisChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KinesisChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.kinesis.";
    private static final String PROP_REGION_NAME = "debezium.sink.kinesis.region";
    private static final String PROP_ENDPOINT_NAME = "debezium.sink.kinesis.endpoint";
    private static final String PROP_CREDENTIALS_PROFILE = "debezium.sink.kinesis.credentials.profile";
    private String region;
    private Optional<String> endpointOverride;
    private Optional<String> credentialsProfile;
    private static final int DEFAULT_RETRIES = 5;
    private static final Duration RETRY_INTERVAL = Duration.ofSeconds(1L);
    @ConfigProperty(name="debezium.sink.kinesis.null.key", defaultValue="default")
    String nullKey;
    private KinesisClient client = null;
    @Inject
    @CustomConsumerBuilder
    Instance<KinesisClient> customClient;

    @PostConstruct
    void connect() {
        if (this.customClient.isResolvable()) {
            this.client = (KinesisClient)this.customClient.get();
            LOGGER.info("Obtained custom configured KinesisClient '{}'", (Object)this.client);
            return;
        }
        Config config = ConfigProvider.getConfig();
        this.region = (String)config.getValue(PROP_REGION_NAME, String.class);
        this.endpointOverride = config.getOptionalValue(PROP_ENDPOINT_NAME, String.class);
        this.credentialsProfile = config.getOptionalValue(PROP_CREDENTIALS_PROFILE, String.class);
        KinesisClientBuilder builder = (KinesisClientBuilder)KinesisClient.builder().region(Region.of((String)this.region));
        this.endpointOverride.ifPresent(endpoint -> builder.endpointOverride(URI.create(endpoint)));
        this.credentialsProfile.ifPresent(profile -> builder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)profile)));
        this.client = (KinesisClient)builder.build();
        LOGGER.info("Using default KinesisClient '{}'", (Object)this.client);
    }

    @PreDestroy
    void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception while closing Kinesis client: {}", (Throwable)e);
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> record : records) {
            LOGGER.trace("Received event '{}'", record);
            int attempts = 0;
            while (!this.recordSent(record)) {
                if (++attempts >= 5) {
                    throw new DebeziumException("Exceeded maximum number of attempts to publish event " + record);
                }
                Metronome.sleeper((Duration)RETRY_INTERVAL, (Clock)Clock.SYSTEM).pause();
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    private boolean recordSent(ChangeEvent<Object, Object> record) {
        Object rv = record.value();
        if (rv == null) {
            rv = "";
        }
        PutRecordRequest putRecord = (PutRecordRequest)PutRecordRequest.builder().partitionKey(record.key() != null ? this.getString(record.key()) : this.nullKey).streamName(this.streamNameMapper.map(record.destination())).data(SdkBytes.fromByteArray((byte[])this.getBytes(rv))).build();
        try {
            this.client.putRecord(putRecord);
            return true;
        }
        catch (KinesisException exception) {
            LOGGER.warn("Failed to send record to {}", (Object)record.destination(), (Object)exception);
            return false;
        }
    }
}

