/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.kinesis;

import io.debezium.server.DebeziumServer;
import io.debezium.server.TestDatabase;
import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.events.ConnectorStartedEvent;
import io.debezium.server.kinesis.KinesisTestConfigSource;
import io.debezium.util.Testing;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@QuarkusTest
public class KinesisIT {
    private static final int MESSAGE_COUNT = 4;
    private static final String STREAM_NAME = "testc.inventory.customers";
    protected static TestDatabase db = null;
    protected static KinesisClient kinesis = null;
    @Inject
    DebeziumServer server;

    public KinesisIT() {
        Testing.Files.delete((Path)KinesisTestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)KinesisTestConfigSource.OFFSET_STORE_PATH);
    }

    @AfterAll
    static void stop() {
        if (db != null) {
            db.stop();
        }
    }

    void setupDependencies(@Observes ConnectorStartedEvent event) {
        kinesis = (KinesisClient)((KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().region(Region.of((String)"eu-central-1"))).credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)"default"))).build();
        db = new TestDatabase();
        db.start();
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            throw (Exception)event.getError().get();
        }
    }

    @Test
    public void testKinesis() throws Exception {
        Testing.Print.enable();
        GetShardIteratorResponse iteratorResponse = kinesis.getShardIterator((GetShardIteratorRequest)GetShardIteratorRequest.builder().streamName(STREAM_NAME).shardIteratorType(ShardIteratorType.TRIM_HORIZON).shardId("0").build());
        ArrayList records = new ArrayList();
        Awaitility.await().atMost(Duration.ofSeconds(KinesisTestConfigSource.waitForSeconds())).until(() -> {
            GetRecordsResponse recordsResponse = kinesis.getRecords((GetRecordsRequest)GetRecordsRequest.builder().shardIterator(iteratorResponse.shardIterator()).limit(Integer.valueOf(4)).build());
            records.addAll(recordsResponse.records());
            return records.size() >= 4;
        });
    }
}

