/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.infinispan;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.CustomConsumerBuilder;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="infinispan")
@Dependent
public class InfinispanSinkConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanSinkConsumer.class);
    private static final String CONF_PREFIX = "debezium.sink.infinispan.";
    private static final String SERVER_HOST = "debezium.sink.infinispan.server.host";
    private static final String SERVER_PORT = "debezium.sink.infinispan.server.port";
    private static final String CACHE_NAME = "debezium.sink.infinispan.cache";
    private static final String USER_NAME = "debezium.sink.infinispan.user";
    private static final String PASSWORD = "debezium.sink.infinispan.password";
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache cache;
    @Inject
    @CustomConsumerBuilder
    Instance<RemoteCache> customCache;

    @PostConstruct
    void connect() {
        if (this.customCache.isResolvable()) {
            this.cache = (RemoteCache)this.customCache.get();
            LOGGER.info("Obtained custom cache with configuration '{}'", (Object)this.cache.getRemoteCacheContainer().getConfiguration());
            return;
        }
        Config config = ConfigProvider.getConfig();
        String serverHost = (String)config.getValue(SERVER_HOST, String.class);
        String cacheName = (String)config.getValue(CACHE_NAME, String.class);
        Integer serverPort = config.getOptionalValue(SERVER_PORT, Integer.class).orElse(11222);
        Optional user = config.getOptionalValue(USER_NAME, String.class);
        Optional password = config.getOptionalValue(PASSWORD, String.class);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        String uri = user.isPresent() && password.isPresent() ? String.format("hotrod://%s:%s@%s:%d", user.get(), password.get(), serverHost, serverPort) : String.format("hotrod://%s:%d", serverHost, serverPort);
        LOGGER.info("Connecting to the Infinispan server using URI '{}'", (Object)uri);
        builder.uri(uri);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.cache = this.remoteCacheManager.getCache(cacheName);
        LOGGER.info("Connected to the Infinispan server {}", (Object)this.remoteCacheManager.getServers()[0]);
    }

    @PreDestroy
    void close() {
        try {
            if (this.remoteCacheManager != null) {
                this.remoteCacheManager.close();
                LOGGER.info("Connection to Infinispan server closed.");
            }
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        HashMap<Object, Object> entries = new HashMap<Object, Object>(records.size());
        for (ChangeEvent<Object, Object> record : records) {
            if (record.value() == null) continue;
            LOGGER.trace("Received event {} = '{}'", (Object)this.getString(record.key()), (Object)this.getString(record.value()));
            entries.put(record.key(), record.value());
        }
        try {
            this.cache.putAll(entries);
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
        for (ChangeEvent<Object, Object> record : records) {
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }
}

