/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http.jwt;

import io.debezium.server.http.jwt.JWTAuthenticator;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Optional;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class JWTAuthenticatorTest {
    @Test
    public void generateInitialAuthenticationRequest() throws URISyntaxException {
        URI authURI = new URI("http://test.com/auth/authenticate");
        URI refreshURI = new URI("http://test.com/auth/refreshToken");
        JWTAuthenticator authenticator = new JWTAuthenticator(authURI, refreshURI, "testUser", "testPassword", 10000L, 10000L, Duration.ofMillis(100000L));
        HttpRequest initialRequest = authenticator.generateInitialAuthenticationRequest();
        Assertions.assertEquals((Object)initialRequest.uri(), (Object)authURI);
        Assertions.assertTrue((boolean)initialRequest.method().equalsIgnoreCase("POST"));
        Assertions.assertTrue((boolean)initialRequest.bodyPublisher().isPresent());
    }

    @Test
    public void generateRefreshAuthenticationRequest() throws URISyntaxException {
        URI authURI = new URI("http://test.com/auth/authenticate");
        URI refreshURI = new URI("http://test.com/auth/refreshToken");
        JWTAuthenticator authenticator = new JWTAuthenticator(authURI, refreshURI, "testUser", "testPassword", 10000L, 10000L, Duration.ofMillis(100000L));
        authenticator.setJwtToken("fakeToken");
        authenticator.setJwtRefreshToken("fakeRefreshToken");
        authenticator.setAuthenticationState(JWTAuthenticator.AuthenticationState.EXPIRED);
        HttpRequest initialRequest = authenticator.generateRefreshAuthenticationRequest();
        Assertions.assertEquals((Object)initialRequest.uri(), (Object)refreshURI);
        Assertions.assertTrue((boolean)initialRequest.method().equalsIgnoreCase("POST"));
        Assertions.assertTrue((boolean)initialRequest.bodyPublisher().isPresent());
    }

    @Test
    public void addAuthorizationHeader() throws URISyntaxException {
        URI authURI = new URI("http://test.com/auth/authenticate");
        URI refreshURI = new URI("http://test.com/auth/refreshToken");
        JWTAuthenticator authenticator = new JWTAuthenticator(authURI, refreshURI, "testUser", "testPassword", 10000L, 10000L, Duration.ofMillis(100000L));
        authenticator.setJwtToken("fakeToken");
        authenticator.setAuthenticationState(JWTAuthenticator.AuthenticationState.ACTIVE);
        URI testURI = new URI("http://test.com/cookies");
        HttpRequest.Builder builder = HttpRequest.newBuilder(testURI);
        authenticator.setAuthorizationHeader(builder);
        HttpRequest request = builder.build();
        HttpHeaders headers = request.headers();
        Optional<String> authValue = headers.firstValue("Authorization");
        HttpRequest initialRequest = authenticator.generateInitialAuthenticationRequest();
        Assertions.assertTrue((boolean)authValue.isPresent());
        Assertions.assertEquals((Object)authValue.get(), (Object)"Bearer: fakeToken");
    }
}

