/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http.jwt;

import io.debezium.server.http.jwt.JWTAuthenticator;
import io.debezium.server.http.jwt.JWTAuthenticatorBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class JWTAuthenticatorBuilderTest {
    @Test
    public void verifyBuild() throws URISyntaxException {
        JWTAuthenticatorBuilder builder = new JWTAuthenticatorBuilder();
        builder.setAuthUri(new URI("http://test.com/auth/authenticate"));
        builder.setRefreshUri(new URI("http://test.com/auth/refreshToken"));
        builder.setUsername("testUser");
        builder.setPassword("testPassword");
        JWTAuthenticator authenticator = builder.build();
    }

    @Test
    public void verifyBuildFromConfig() throws URISyntaxException {
        Map<String, String> configValues = Map.of("debezium.sink.http.jwt.url", "http://test.com/", "debezium.sink.http.jwt.username", "testUser", "debezium.sink.http.jwt.password", "testPassword");
        Config result = (Config)Mockito.mock(Config.class);
        for (Map.Entry<String, String> entry : configValues.entrySet()) {
            String value = entry.getValue();
            Mockito.when((Object)result.getValue((String)ArgumentMatchers.eq((Object)entry.getKey()), (Class)ArgumentMatchers.any())).thenReturn((Object)value);
            Mockito.when((Object)result.getOptionalValue((String)ArgumentMatchers.eq((Object)entry.getKey()), (Class)ArgumentMatchers.any())).thenReturn(Optional.of(value));
        }
        JWTAuthenticatorBuilder builder = JWTAuthenticatorBuilder.fromConfig((Config)result, (String)"debezium.sink.http.");
        builder.setRefreshUri(new URI("http://test.com"));
        builder.setUsername("testUser");
        builder.setPassword("testPassword");
        JWTAuthenticator authenticator = builder.build();
    }
}

