/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class HttpTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTestResourceLifecycleManager.class);
    public static final String WIREMOCK_IMAGE = "wiremock/wiremock:3.2.0";
    public static final int PORT = 8080;
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final GenericContainer<?> container = new GenericContainer("wiremock/wiremock:3.2.0").withExposedPorts(new Integer[]{8080});

    private static synchronized void init() {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public Map<String, String> start() {
        HttpTestResourceLifecycleManager.init();
        return Map.of("debezium.sink.http.url", this.getURL());
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }

    private String getURL() {
        return "http://" + container.getHost() + ":" + container.getMappedPort(8080);
    }

    public static String getHost() {
        return container.getHost();
    }

    public static int getPort() {
        return container.getMappedPort(8080);
    }

    public static void reset() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            String resetURL = "http://" + container.getHost() + ":" + container.getMappedPort(8080) + "/__admin/reset";
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(new URI(resetURL)).timeout(Duration.ofMillis(60000L));
            HttpRequest request = requestBuilder.POST(HttpRequest.BodyPublishers.ofString("")).build();
            HttpResponse<String> r = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (r.statusCode() != 200) {
                throw new IllegalStateException("Get wrong response while resetting WireMock: " + r.statusCode());
            }
            LOGGER.info("WireMock reset");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reset WireMock", (Throwable)e);
        }
    }
}

