/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.http.Authenticator;
import io.debezium.server.http.jwt.JWTAuthenticatorBuilder;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="http")
@Dependent
public class HttpChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpChangeConsumer.class);
    public static final String PROP_PREFIX = "debezium.sink.http.";
    public static final String PROP_WEBHOOK_URL = "url";
    public static final String PROP_CLIENT_TIMEOUT = "timeout.ms";
    public static final String PROP_RETRIES = "retries";
    public static final String PROP_RETRY_INTERVAL = "retry.interval.ms";
    public static final String PROP_HEADERS_ENCODE_BASE64 = "headers.encode.base64";
    public static final String PROP_HEADERS_PREFIX = "headers.prefix";
    public static final String PROP_AUTHENTICATION_PREFIX = "debezium.sink.http.authentication.";
    public static final String PROP_AUTHENTICATION_TYPE = "type";
    public static final String JWT_AUTHENTICATION = "jwt";
    private static final Long HTTP_TIMEOUT = Integer.toUnsignedLong(60000);
    private static final int DEFAULT_RETRIES = 5;
    private static final Long RETRY_INTERVAL = Integer.toUnsignedLong(1000);
    private static final String DEFAULT_HEADERS_PREFIX = "X-DEBEZIUM-";
    private static Duration timeoutDuration;
    private static int retries;
    private static Duration retryInterval;
    private boolean base64EncodeHeaders = true;
    private String headersPrefix = "X-DEBEZIUM-";
    private HttpClient client;
    private HttpRequest.Builder requestBuilder;
    private Authenticator authenticator;

    @PostConstruct
    void connect() throws URISyntaxException {
        Config config = ConfigProvider.getConfig();
        this.initWithConfig(config);
    }

    void initWithConfig(Config config) throws URISyntaxException {
        String contentType;
        this.client = HttpClient.newHttpClient();
        String sink = System.getenv("K_SINK");
        timeoutDuration = Duration.ofMillis(HTTP_TIMEOUT);
        retries = 5;
        retryInterval = Duration.ofMillis(RETRY_INTERVAL);
        String sinkUrl = sink != null ? sink : (String)config.getValue("debezium.sink.http.url", String.class);
        config.getOptionalValue("debezium.sink.http.timeout.ms", String.class).ifPresent(t -> {
            timeoutDuration = Duration.ofMillis(Long.parseLong(t));
        });
        config.getOptionalValue("debezium.sink.http.retries", String.class).ifPresent(n -> {
            retries = Integer.parseInt(n);
        });
        config.getOptionalValue("debezium.sink.http.retry.interval.ms", String.class).ifPresent(t -> {
            retryInterval = Duration.ofMillis(Long.parseLong(t));
        });
        config.getOptionalValue("debezium.sink.http.headers.prefix", String.class).ifPresent(p -> {
            this.headersPrefix = p;
        });
        config.getOptionalValue("debezium.sink.http.headers.encode.base64", Boolean.class).ifPresent(b -> {
            this.base64EncodeHeaders = b;
        });
        switch ((String)config.getValue("debezium.format.value", String.class)) {
            case "avro": {
                contentType = "avro/bytes";
                break;
            }
            case "cloudevents": {
                contentType = "application/cloudevents+json";
                break;
            }
            default: {
                contentType = "application/json";
            }
        }
        Optional authenticationType = config.getOptionalValue("debezium.sink.http.authentication.type", String.class);
        if (authenticationType.isPresent()) {
            String t2 = (String)authenticationType.get();
            if (t2.equalsIgnoreCase(JWT_AUTHENTICATION)) {
                JWTAuthenticatorBuilder builder = JWTAuthenticatorBuilder.fromConfig(config, PROP_AUTHENTICATION_PREFIX);
                this.authenticator = builder.build();
            } else {
                throw new DebeziumException("Unknown value '" + t2 + "' encountered for property debezium.sink.http.authentication.type");
            }
        }
        LOGGER.info("Using http content-type type {}", (Object)contentType);
        LOGGER.info("Using sink URL: {}", (Object)sinkUrl);
        this.requestBuilder = HttpRequest.newBuilder(new URI(sinkUrl)).timeout(timeoutDuration);
        this.requestBuilder.setHeader("content-type", contentType);
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> record : records) {
            LOGGER.trace("Received event '{}'", record);
            if (record.value() == null) continue;
            int attempts = 0;
            while (!this.recordSent(record)) {
                if (++attempts >= retries) {
                    throw new DebeziumException("Exceeded maximum number of attempts to publish event " + record);
                }
                Metronome.sleeper((Duration)retryInterval, (Clock)Clock.SYSTEM).pause();
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    private boolean recordSent(ChangeEvent<Object, Object> record) throws InterruptedException {
        HttpResponse<String> r;
        boolean sent = false;
        HttpRequest.Builder requestBuilder = this.generateRequest(record);
        try {
            if (this.authenticator != null) {
                if (!this.authenticator.authenticate()) {
                    throw new DebeziumException("Failed to authenticate successfully.  Cannot continue.");
                }
                this.authenticator.setAuthorizationHeader(requestBuilder);
            }
            HttpRequest request = requestBuilder.build();
            r = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException ioe) {
            throw new InterruptedException(ioe.toString());
        }
        if (r.statusCode() == 200 || r.statusCode() == 204 || r.statusCode() == 202) {
            sent = true;
        } else {
            LOGGER.info("Failed to publish event: " + r.body());
        }
        return sent;
    }

    HttpRequest.Builder generateRequest(ChangeEvent<Object, Object> record) {
        String value = (String)record.value();
        HttpRequest.Builder builder = this.requestBuilder.POST(HttpRequest.BodyPublishers.ofString(value));
        Map headers = this.convertHeaders(record);
        for (Map.Entry entry : headers.entrySet()) {
            String headerValue = (String)entry.getValue();
            if (this.base64EncodeHeaders) {
                headerValue = Base64.getEncoder().encodeToString(headerValue.getBytes(StandardCharsets.UTF_8));
            }
            builder.header(this.headersPrefix + ((String)entry.getKey()).toUpperCase(Locale.ROOT), headerValue);
        }
        return builder;
    }
}

