/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http.jwt;

import io.debezium.DebeziumException;
import io.debezium.server.http.jwt.JWTAuthenticator;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthenticatorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JWTAuthenticatorBuilder.class);
    private static final long HTTP_TIMEOUT = Integer.toUnsignedLong(60000);
    private static final String PROP_USERNAME = "jwt.username";
    private static final String PROP_PASSWORD = "jwt.password";
    private static final String PROP_URL = "jwt.url";
    private static final String PROP_TOKEN_EXPIRATION = "jwt.token_expiration";
    private static final String PROP_RENEW_TOKEN_EXPIRATION = "jwt.refresh_token_expiration";
    private static final String AUTHENTICATE_PATH = "auth/authenticate";
    private static final String REFRESH_PATH = "auth/refreshToken";
    private URI authUri;
    private URI refreshUri;
    private String username;
    private String password;
    private long tokenExpirationDuration = Integer.toUnsignedLong(60);
    private long refreshTokenExpirationDuration = Integer.toUnsignedLong(1440);
    private Duration httpTimeoutDuration = Duration.ofMillis(HTTP_TIMEOUT);

    public static JWTAuthenticatorBuilder fromConfig(Config config, String prop_prefix) {
        JWTAuthenticatorBuilder builder = new JWTAuthenticatorBuilder();
        builder.setUsername((String)config.getValue(prop_prefix + PROP_USERNAME, String.class));
        builder.setPassword((String)config.getValue(prop_prefix + PROP_PASSWORD, String.class));
        String uriString = (String)config.getValue(prop_prefix + PROP_URL, String.class);
        try {
            LOGGER.info("Authentication URL is " + uriString + AUTHENTICATE_PATH);
            URI authUri = new URI(uriString + AUTHENTICATE_PATH);
            builder.setAuthUri(authUri);
        }
        catch (URISyntaxException e) {
            throw new DebeziumException("Could not parse authentication URL: " + uriString + AUTHENTICATE_PATH, (Throwable)e);
        }
        try {
            LOGGER.info("Authentication URL is " + uriString + REFRESH_PATH);
            URI refreshUri = new URI(uriString + REFRESH_PATH);
            builder.setRefreshUri(refreshUri);
        }
        catch (URISyntaxException e) {
            throw new DebeziumException("Could not parse refresh URL: " + uriString + REFRESH_PATH, (Throwable)e);
        }
        config.getOptionalValue(prop_prefix + PROP_TOKEN_EXPIRATION, Long.class).ifPresent(builder::setTokenExpirationDuration);
        config.getOptionalValue(prop_prefix + PROP_RENEW_TOKEN_EXPIRATION, Long.class).ifPresent(builder::setRefreshTokenExpirationDuration);
        return builder;
    }

    public void setRefreshUri(URI refreshUri) {
        this.refreshUri = refreshUri;
    }

    public JWTAuthenticatorBuilder setAuthUri(URI authUri) {
        this.authUri = authUri;
        return this;
    }

    public JWTAuthenticatorBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public JWTAuthenticatorBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public JWTAuthenticatorBuilder setTokenExpirationDuration(long tokenExpirationDuration) {
        this.tokenExpirationDuration = tokenExpirationDuration;
        return this;
    }

    public JWTAuthenticatorBuilder setRefreshTokenExpirationDuration(long refreshTokenExpirationDuration) {
        this.refreshTokenExpirationDuration = refreshTokenExpirationDuration;
        return this;
    }

    public JWTAuthenticatorBuilder setHttpTimeoutDuration(long timeoutDuration) {
        this.httpTimeoutDuration = Duration.ofMillis(timeoutDuration);
        return this;
    }

    public JWTAuthenticator build() {
        if (this.authUri == null) {
            String msg = "Cannot build JWTAuthenticator.  Initialization authorization URI must be set.";
            LOGGER.error(msg);
            throw new NoSuchElementException(msg);
        }
        if (this.refreshUri == null) {
            String msg = "Cannot build JWTAuthenticator.  Refresh authorization URI must be set.";
            LOGGER.error(msg);
            throw new NoSuchElementException(msg);
        }
        if (this.username == null) {
            String msg = "Cannot build JWTAuthenticator.  Username must be set.";
            LOGGER.error(msg);
            throw new NoSuchElementException(msg);
        }
        if (this.password == null) {
            String msg = "Cannot build JWTAuthenticator.  Password must be set.";
            LOGGER.error(msg);
            throw new NoSuchElementException(msg);
        }
        return new JWTAuthenticator(this.authUri, this.refreshUri, this.username, this.password, this.tokenExpirationDuration, this.refreshTokenExpirationDuration, this.httpTimeoutDuration);
    }
}

