/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.inject.Inject;
import io.debezium.DebeziumException;
import io.debezium.doc.FixFor;
import io.debezium.server.DebeziumServer;
import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.http.HttpTestConfigSource;
import io.debezium.server.http.HttpTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.enterprise.event.Observes;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class), @QuarkusTestResource(value=HttpTestResourceLifecycleManager.class)})
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class HttpIT {
    @Inject
    DebeziumServer server;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpIT.class);
    private static final int MESSAGE_COUNT = 4;
    private static final int EXPECTED_RETRIES = 5;
    private boolean expectServerFail = false;
    private String expectedErrorMessage;

    public HttpIT() {
        Testing.Files.delete((Path)HttpTestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)HttpTestConfigSource.OFFSET_STORE_PATH);
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            Exception e = (Exception)event.getError().get();
            if (e instanceof DebeziumException && this.expectServerFail && e.getMessage().equals(this.expectedErrorMessage)) {
                LOGGER.info("Expected server failure: {}", (Throwable)e);
                return;
            }
            throw e;
        }
    }

    @BeforeEach
    public void resetHttpMock() {
        HttpTestResourceLifecycleManager.reset();
    }

    @Test
    @Order(value=1)
    @FixFor(value={"DBZ-5307"})
    public void testRetryUponError() {
        Testing.Print.enable();
        this.expectServerFail = true;
        this.expectedErrorMessage = "Exceeded maximum number of attempts to publish event EmbeddedEngineChangeEvent";
        ArrayList<ServeEvent> events = new ArrayList<ServeEvent>();
        WireMock.configureFor((String)HttpTestResourceLifecycleManager.getHost(), (int)HttpTestResourceLifecycleManager.getPort());
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/").willReturn(WireMock.aResponse().withStatus(500)));
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> {
            events.addAll(WireMock.getAllServeEvents());
            return events.size() == 5;
        });
        this.assertEvents(events, 5);
    }

    @Test
    @Order(value=2)
    public void testHttpServer() {
        Testing.Print.enable();
        this.expectServerFail = false;
        ArrayList<ServeEvent> events = new ArrayList<ServeEvent>();
        WireMock.configureFor((String)HttpTestResourceLifecycleManager.getHost(), (int)HttpTestResourceLifecycleManager.getPort());
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/").willReturn(WireMock.aResponse().withStatus(200)));
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> {
            List currentEvents = WireMock.getAllServeEvents();
            events.addAll(currentEvents);
            for (ServeEvent e : currentEvents) {
                WireMock.removeServeEvent((UUID)e.getId());
            }
            return events.size() == 4;
        });
        this.assertEvents(events, 4);
    }

    private void assertEvents(List<ServeEvent> events, int expectedSize) {
        Assertions.assertEquals((int)expectedSize, (int)events.size());
        for (ServeEvent e : events) {
            LoggedRequest request = e.getRequest();
            Assertions.assertEquals((Object)request.getHeader("content-type"), (Object)"application/cloudevents+json");
            Assertions.assertTrue((boolean)request.containsHeader("X-DEBEZIUM-HEADERKEY"));
            try {
                ObjectMapper om = new ObjectMapper();
                TypeReference<HashMap<String, Object>> tref = new TypeReference<HashMap<String, Object>>(){};
                HashMap hm = (HashMap)om.readValue(request.getBody(), (TypeReference)tref);
                Assertions.assertEquals((Object)"/debezium/postgresql/testc", (Object)((String)hm.get("source")));
                Assertions.assertEquals((Object)"io.debezium.postgresql.datachangeevent", (Object)((String)hm.get("type")));
                Assertions.assertEquals((Object)"1.0", (Object)((String)hm.get("specversion")));
                Assertions.assertEquals((Object)"postgres", (Object)((String)hm.get("iodebeziumdb")));
                Assertions.assertEquals((Object)"inventory", (Object)((String)hm.get("iodebeziumschema")));
                Assertions.assertEquals((Object)"customers", (Object)((String)hm.get("iodebeziumtable")));
                String eventID = (String)hm.get("id");
                Assertions.assertTrue((eventID.length() > 0 ? 1 : 0) != 0);
            }
            catch (IOException ioe) {
                Assertions.fail((Throwable)ioe);
            }
        }
    }
}

