/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import io.debezium.engine.ChangeEvent;
import io.debezium.engine.Header;
import io.debezium.server.http.HttpChangeConsumer;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class HttpChangeConsumerTest {
    @Test
    public void verifyGenerateRequestWithDefaultConfig() throws URISyntaxException {
        HttpChangeConsumer changeConsumer = new HttpChangeConsumer();
        changeConsumer.initWithConfig(this.generateMockConfig(Map.of("debezium.sink.http.url", "http://url", "debezium.format.value", "avro")));
        HttpRequest request = changeConsumer.generateRequest(HttpChangeConsumerTest.createChangeEvent());
        String value = request.headers().firstValue("X-DEBEZIUM-h1key").orElse(null);
        Assertions.assertEquals((Object)"aDFWYWx1ZQ==", (Object)value);
    }

    @Test
    public void verifyGenerateRequestWithBase64EncodingDisabled() throws URISyntaxException {
        HttpChangeConsumer changeConsumer = new HttpChangeConsumer();
        changeConsumer.initWithConfig(this.generateMockConfig(Map.of("debezium.sink.http.headers.encode.base64", false, "debezium.sink.http.url", "http://url", "debezium.format.value", "avro")));
        HttpRequest request = changeConsumer.generateRequest(HttpChangeConsumerTest.createChangeEvent());
        String value = request.headers().firstValue("X-DEBEZIUM-h1key").orElse(null);
        Assertions.assertEquals((Object)"h1Value", (Object)value);
    }

    @Test
    public void verifyGenerateRequestWithDifferentHeaderPrefix() throws URISyntaxException {
        HttpChangeConsumer changeConsumer = new HttpChangeConsumer();
        changeConsumer.initWithConfig(this.generateMockConfig(Map.of("debezium.sink.http.headers.encode.base64", false, "debezium.sink.http.headers.prefix", "XYZ-DBZ-", "debezium.sink.http.url", "http://url", "debezium.format.value", "avro")));
        HttpRequest request = changeConsumer.generateRequest(HttpChangeConsumerTest.createChangeEvent());
        String value = request.headers().firstValue("XYZ-DBZ-h1key").orElse(null);
        Assertions.assertEquals((Object)"h1Value", (Object)value);
    }

    private static ChangeEvent<Object, Object> createChangeEvent() {
        ChangeEvent result = (ChangeEvent)Mockito.mock(ChangeEvent.class);
        Mockito.when((Object)result.key()).thenReturn((Object)"key");
        Mockito.when((Object)result.value()).thenReturn((Object)"value");
        Mockito.when((Object)result.destination()).thenReturn((Object)"dest");
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.getKey()).thenReturn((Object)"h1Key");
        Mockito.when((Object)header.getValue()).thenReturn((Object)"h1Value");
        Mockito.when((Object)result.headers()).thenReturn(List.of(header));
        return result;
    }

    private Config generateMockConfig(Map<String, Object> config) {
        Config result = (Config)Mockito.mock(Config.class);
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            Object value = entry.getValue();
            Mockito.when((Object)result.getValue((String)ArgumentMatchers.eq((Object)entry.getKey()), (Class)ArgumentMatchers.any())).thenReturn(value);
            Mockito.when((Object)result.getOptionalValue((String)ArgumentMatchers.eq((Object)entry.getKey()), (Class)ArgumentMatchers.any())).thenReturn(Optional.of(value));
        }
        return result;
    }
}

