/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testcontainers.containers.GenericContainer;

public class HttpTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final String WIREMOCK_IMAGE = "docker.io/wiremock/wiremock:latest";
    public static final int PORT = 8080;
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final GenericContainer<?> container = new GenericContainer("docker.io/wiremock/wiremock:latest").withExposedPorts(new Integer[]{8080});

    private static synchronized void init() {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public Map<String, String> start() {
        HttpTestResourceLifecycleManager.init();
        return Collections.singletonMap("debezium.sink.http.url", this.getURL());
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }

    private String getURL() {
        return "http://" + container.getHost() + ":" + container.getMappedPort(8080);
    }

    public static String getHost() {
        return container.getHost();
    }

    public static int getPort() {
        return container.getMappedPort(8080);
    }
}

