/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.inject.Inject;
import io.debezium.server.DebeziumServer;
import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.http.HttpTestConfigSource;
import io.debezium.server.http.HttpTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import javax.enterprise.event.Observes;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class), @QuarkusTestResource(value=HttpTestResourceLifecycleManager.class)})
public class HttpIT {
    @Inject
    DebeziumServer server;
    private static final int MESSAGE_COUNT = 4;

    public HttpIT() {
        Testing.Files.delete((Path)HttpTestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)HttpTestConfigSource.OFFSET_STORE_PATH);
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            throw (Exception)event.getError().get();
        }
    }

    @Test
    public void testHttpServer() {
        Testing.Print.enable();
        ArrayList events = new ArrayList();
        WireMock.configureFor((String)HttpTestResourceLifecycleManager.getHost(), (int)HttpTestResourceLifecycleManager.getPort());
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/").willReturn(WireMock.aResponse().withStatus(200)));
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> {
            events.addAll(WireMock.getAllServeEvents());
            return events.size() == 4;
        });
        Assertions.assertEquals((int)4, (int)events.size());
        for (ServeEvent e : events) {
            LoggedRequest request = e.getRequest();
            Assertions.assertEquals((Object)request.getHeader("content-type"), (Object)"application/cloudevents+json");
            try {
                ObjectMapper om = new ObjectMapper();
                TypeReference<HashMap<String, Object>> tref = new TypeReference<HashMap<String, Object>>(){};
                HashMap hm = (HashMap)om.readValue(request.getBody(), (TypeReference)tref);
                Assertions.assertEquals((Object)"/debezium/postgresql/testc", (Object)((String)hm.get("source")));
                Assertions.assertEquals((Object)"io.debezium.postgresql.datachangeevent", (Object)((String)hm.get("type")));
                Assertions.assertEquals((Object)"1.0", (Object)((String)hm.get("specversion")));
                Assertions.assertEquals((Object)"postgres", (Object)((String)hm.get("iodebeziumdb")));
                Assertions.assertEquals((Object)"inventory", (Object)((String)hm.get("iodebeziumschema")));
                Assertions.assertEquals((Object)"customers", (Object)((String)hm.get("iodebeziumtable")));
                String eventID = (String)hm.get("id");
                Assertions.assertTrue((eventID.length() > 0 ? 1 : 0) != 0);
            }
            catch (IOException ioe) {
                Assertions.fail((Throwable)ioe);
            }
        }
    }
}

