/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.eventhubs;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.messaging.eventhubs.models.CreateBatchOptions;

public class EventDataBatchProxy {
    private EventDataBatch batch;
    private final EventHubProducerClient producer;
    private final CreateBatchOptions batchOptions;

    public EventDataBatchProxy(EventHubProducerClient producer, CreateBatchOptions batchOptions) {
        this.producer = producer;
        this.batchOptions = batchOptions;
    }

    public boolean tryAdd(EventData eventData) {
        if (this.batch == null) {
            this.batch = this.producer.createBatch(this.batchOptions);
        }
        return this.batch.tryAdd(eventData);
    }

    public int getCount() {
        if (this.batch == null) {
            return 0;
        }
        return this.batch.getCount();
    }

    public void emit() {
        if (this.batch == null) {
            return;
        }
        this.producer.send(this.batch);
    }
}

