/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.eventhubs;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.messaging.eventhubs.models.CreateBatchOptions;
import io.debezium.DebeziumException;
import io.debezium.server.eventhubs.EventDataBatchProxy;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchManager.class);
    private final EventHubProducerClient producer;
    private final String configuredPartitionId;
    private final String configuredPartitionKey;
    private final Integer maxBatchSize;
    static final Integer BATCH_INDEX_FOR_NO_PARTITION_ID = -1;
    static final Integer BATCH_INDEX_FOR_PARTITION_KEY = 0;
    private final HashMap<Integer, CreateBatchOptions> batchOptions = new HashMap();
    private final HashMap<Integer, EventDataBatchProxy> batches = new HashMap();

    public BatchManager(EventHubProducerClient producer, String configurePartitionId, String configuredPartitionKey, Integer maxBatchSize) {
        this.producer = producer;
        this.configuredPartitionId = configurePartitionId;
        this.configuredPartitionKey = configuredPartitionKey;
        this.maxBatchSize = maxBatchSize;
    }

    public void initializeBatch() {
        if (!this.configuredPartitionId.isEmpty() || !this.configuredPartitionKey.isEmpty()) {
            CreateBatchOptions op = new CreateBatchOptions();
            if (!this.configuredPartitionId.isEmpty()) {
                op.setPartitionId(this.configuredPartitionId);
                this.batchOptions.put(Integer.parseInt(this.configuredPartitionId), op);
                this.batches.put(Integer.parseInt(this.configuredPartitionId), new EventDataBatchProxy(this.producer, op));
            } else if (!this.configuredPartitionKey.isEmpty()) {
                op.setPartitionKey(this.configuredPartitionKey);
                this.batchOptions.put(BATCH_INDEX_FOR_PARTITION_KEY, op);
                this.batches.put(BATCH_INDEX_FOR_PARTITION_KEY, new EventDataBatchProxy(this.producer, op));
            }
            if (this.maxBatchSize != 0) {
                op.setMaximumSizeInBytes(this.maxBatchSize.intValue());
            }
            return;
        }
        CreateBatchOptions op = new CreateBatchOptions();
        if (this.maxBatchSize != 0) {
            op.setMaximumSizeInBytes(this.maxBatchSize.intValue());
        }
        this.batchOptions.put(BATCH_INDEX_FOR_NO_PARTITION_ID, op);
        this.producer.getPartitionIds().stream().forEach(partitionId -> {
            CreateBatchOptions createBatchOptionsForPartitionId = new CreateBatchOptions().setPartitionId(partitionId);
            if (this.maxBatchSize != 0) {
                createBatchOptionsForPartitionId.setMaximumSizeInBytes(this.maxBatchSize.intValue());
            }
            this.batchOptions.put(Integer.parseInt(partitionId), createBatchOptionsForPartitionId);
        });
        this.batchOptions.forEach((batchIndex, createBatchOptions) -> {
            EventDataBatchProxy batch = new EventDataBatchProxy(this.producer, (CreateBatchOptions)createBatchOptions);
            this.batches.put((Integer)batchIndex, batch);
        });
    }

    public void closeAndEmitBatches() {
        this.batches.forEach((partitionId, batch) -> {
            if (batch.getCount() > 0) {
                LOGGER.trace("Dispatching {} events.", (Object)batch.getCount());
                this.emitBatchToEventHub((EventDataBatchProxy)batch);
            }
        });
    }

    public void sendEventToPartitionId(EventData eventData, Integer recordIndex, Integer partitionId) {
        EventDataBatchProxy batch = this.batches.get(partitionId);
        if (!batch.tryAdd(eventData)) {
            if (batch.getCount() == 0) {
                throw new DebeziumException("Event data is too large to fit into batch");
            }
            LOGGER.debug("Maximum batch size reached, dispatching {} events.", (Object)batch.getCount());
            this.emitBatchToEventHub(batch);
            batch = new EventDataBatchProxy(this.producer, this.batchOptions.get(partitionId));
            this.batches.put(partitionId, batch);
            if (!batch.tryAdd(eventData)) {
                throw new DebeziumException("Event data is too large to fit into batch");
            }
        }
    }

    private void emitBatchToEventHub(EventDataBatchProxy batch) {
        int batchEventSize = batch.getCount();
        if (batchEventSize > 0) {
            try {
                LOGGER.trace("Sending batch of {} events to Event Hubs", (Object)batchEventSize);
                batch.emit();
                LOGGER.trace("Sent record batch to Event Hubs");
            }
            catch (Exception e) {
                throw new DebeziumException((Throwable)e);
            }
        }
    }
}

