/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.server.DebeziumServer;
import io.debezium.server.DebeziumServerFileConfigProviderProfile;
import io.debezium.server.TestConfigSource;
import io.debezium.server.TestConsumer;
import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.events.ConnectorStartedEvent;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperties;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

@QuarkusTest
@TestProfile(value=DebeziumServerFileConfigProviderProfile.class)
@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class)
@EnabledIfSystemProperty(named="test.apicurio", matches="false", disabledReason="DebeziumServerConfigProvidersIT doesn't run with apicurio profile.")
@DisabledIfSystemProperties(value={@DisabledIfSystemProperty(named="debezium.format.key", matches="protobuf"), @DisabledIfSystemProperty(named="debezium.format.value", matches="protobuf")})
public class DebeziumServerConfigProvidersIT {
    private static final int MESSAGE_COUNT = 4;
    @Inject
    DebeziumServer server;

    public DebeziumServerConfigProvidersIT() {
        Testing.Files.delete((Path)TestConfigSource.OFFSET_STORE_PATH);
    }

    void setupDependencies(@Observes ConnectorStartedEvent event) {
        if (!TestConfigSource.isItTest()) {
            return;
        }
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            throw (Exception)event.getError().get();
        }
    }

    @Test
    public void testPostgresWithJson() throws Exception {
        Testing.Print.enable();
        TestConsumer testConsumer = (TestConsumer)this.server.getConsumer();
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> testConsumer.getValues().size() >= 4);
        Assertions.assertThat((int)testConsumer.getValues().size()).isEqualTo(4);
        Assertions.assertThat((String)((String)testConsumer.getValues().get(3))).contains(new CharSequence[]{"\"after\":{\"id\":1004,\"first_name\":\"Anne\",\"last_name\":\"Kretchmar\",\"email\":\"annek@noanswer.org\"}"});
    }
}

