/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.DebeziumException;
import jakarta.enterprise.context.Dependent;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DebeziumMetrics {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DebeziumMetrics.class);
    public static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private ObjectName snapshotMetricsObjectName;
    private ObjectName streamingMetricsObjectName;

    private static ObjectName getDebeziumMbean(String context) {
        ObjectName debeziumMbean = null;
        for (ObjectName mbean : mbeanServer.queryNames(null, null)) {
            if (!mbean.getCanonicalName().contains("debezium.") || !mbean.getCanonicalName().contains("type=connector-metrics") || !mbean.getCanonicalName().contains("context=" + context)) continue;
            LOGGER.debug("Using {} MBean to get {} metrics", (Object)mbean, (Object)context);
            debeziumMbean = mbean;
            break;
        }
        Objects.requireNonNull(debeziumMbean, "Debezium MBean (context=" + context + ") not found!");
        return debeziumMbean;
    }

    public ObjectName getSnapshotMetricsObjectName() {
        if (this.snapshotMetricsObjectName == null) {
            this.snapshotMetricsObjectName = DebeziumMetrics.getDebeziumMbean("snapshot");
        }
        return this.snapshotMetricsObjectName;
    }

    public ObjectName getStreamingMetricsObjectName() {
        if (this.streamingMetricsObjectName == null) {
            this.streamingMetricsObjectName = DebeziumMetrics.getDebeziumMbean("streaming");
        }
        return this.streamingMetricsObjectName;
    }

    public int maxQueueSize() {
        try {
            return (Integer)mbeanServer.getAttribute(this.getStreamingMetricsObjectName(), "QueueTotalCapacity");
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public boolean snapshotRunning() {
        try {
            return (Boolean)mbeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotRunning");
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public boolean snapshotCompleted() {
        try {
            return (Boolean)mbeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted");
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public int streamingQueueRemainingCapacity() {
        try {
            return (Integer)mbeanServer.getAttribute(this.getStreamingMetricsObjectName(), "QueueRemainingCapacity");
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public int streamingQueueCurrentSize() {
        return this.maxQueueSize() - this.streamingQueueRemainingCapacity();
    }

    public long streamingMilliSecondsBehindSource() {
        try {
            return (Long)mbeanServer.getAttribute(this.getStreamingMetricsObjectName(), "MilliSecondsBehindSource");
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public void logMetrics() {
        LOGGER.info("Debezium Metrics: snapshotCompleted={} snapshotRunning={} streamingQueueCurrentSize={} streamingQueueRemainingCapacity={} maxQueueSize={} streamingMilliSecondsBehindSource={}", new Object[]{this.snapshotCompleted(), this.snapshotRunning(), this.streamingQueueCurrentSize(), this.streamingQueueRemainingCapacity(), this.maxQueueSize(), this.streamingMilliSecondsBehindSource()});
    }
}

