/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.Header;
import io.debezium.server.StreamNameMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseChangeConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChangeConsumer.class);
    protected StreamNameMapper streamNameMapper = x -> x;
    @Inject
    Instance<StreamNameMapper> customStreamNameMapper;

    @PostConstruct
    void init() {
        if (this.customStreamNameMapper.isResolvable()) {
            this.streamNameMapper = (StreamNameMapper)this.customStreamNameMapper.get();
        }
        LOGGER.info("Using '{}' stream name mapper", (Object)this.streamNameMapper);
    }

    protected Map<String, Object> getConfigSubset(Config config, String prefix) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String propName : config.getPropertyNames()) {
            if (!propName.startsWith(prefix)) continue;
            String newPropName = propName.substring(prefix.length());
            ret.put(newPropName, config.getConfigValue(propName).getValue());
        }
        return ret;
    }

    protected byte[] getBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes(StandardCharsets.UTF_8);
        }
        throw new DebeziumException(this.unsupportedTypeMessage(object));
    }

    protected String getString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new DebeziumException(this.unsupportedTypeMessage(object));
    }

    protected String unsupportedTypeMessage(Object object) {
        String type = object == null ? "null" : object.getClass().getName();
        return "Unexpected data type '" + type + "'";
    }

    protected Map<String, String> convertHeaders(ChangeEvent<Object, Object> record) {
        List headers = record.headers();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Header header : headers) {
            result.put(header.getKey(), this.getString(header.getValue()));
        }
        return result;
    }
}

