/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.DebeziumException;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.server.DebeziumServer;
import io.debezium.server.TestConfigSource;
import io.debezium.server.TestConsumer;
import io.debezium.server.events.ConnectorStartedEvent;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import io.quarkus.test.junit.QuarkusTest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Properties;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DebeziumServerTest {
    private static final int MESSAGE_COUNT = 5;
    @Inject
    DebeziumServer server;

    public DebeziumServerTest() {
        Testing.Files.delete((Path)TestConfigSource.OFFSET_STORE_PATH);
    }

    void setupDependencies(@Observes ConnectorStartedEvent event) {
        Testing.Files.delete((Path)TestConfigSource.TEST_FILE_PATH);
        Testing.Files.createTestingFile((Path)TestConfigSource.TEST_FILE_PATH);
        DebeziumServerTest.appendLinesToSource(5);
        Testing.Print.enable();
    }

    @Test
    public void testProps() {
        Properties properties = this.server.getProps();
        Assertions.assertThat((String)properties.getProperty(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST.name())).isNotNull();
        Assertions.assertThat((String)properties.getProperty(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST.name())).isEqualTo((Object)"public.table_name");
        Assertions.assertThat((String)properties.getProperty("offset.flush.interval.ms.test")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("offset.flush.interval.ms.test")).isEqualTo((Object)"0");
        Assertions.assertThat((String)properties.getProperty("snapshot.select.statement.overrides.public.table_name")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("snapshot.select.statement.overrides.public.table_name")).isEqualTo((Object)"SELECT * FROM table_name WHERE 1>2");
        Assertions.assertThat((String)properties.getProperty("database.allowPublicKeyRetrieval")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("database.allowPublicKeyRetrieval")).isEqualTo((Object)"true");
        Assertions.assertThat((String)properties.getProperty("transforms.hoist.predicate")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("transforms.hoist.predicate")).isEqualTo((Object)"topicNameMatch");
        Assertions.assertThat((String)properties.getProperty("predicates")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("predicates")).isEqualTo((Object)"topicNameMatch");
        Assertions.assertThat((String)properties.getProperty("predicates.topicNameMatch.type")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("predicates.topicNameMatch.type")).isEqualTo((Object)"org.apache.kafka.connect.transforms.predicates.TopicNameMatches");
        Assertions.assertThat((String)properties.getProperty("predicates.topicNameMatch.pattern")).isNotNull();
        Assertions.assertThat((String)properties.getProperty("predicates.topicNameMatch.pattern")).isEqualTo((Object)".*");
    }

    @Test
    public void testJson() throws Exception {
        TestConsumer testConsumer = (TestConsumer)this.server.getConsumer();
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> testConsumer.getValues().size() >= 5);
        Assertions.assertThat((int)testConsumer.getValues().size()).isEqualTo(5);
        Assertions.assertThat((Object)testConsumer.getValues().get(4)).isEqualTo((Object)"{\"line\":\"5\"}");
    }

    static void appendLinesToSource(int numberOfLines) {
        Object[] lines = new CharSequence[numberOfLines];
        for (int i = 0; i != numberOfLines; ++i) {
            lines[i] = DebeziumServerTest.generateLine(i + 1);
        }
        try {
            Files.write(TestConfigSource.TEST_FILE_PATH, (Iterable<? extends CharSequence>)Collect.arrayListOf((Object[])lines), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    static String generateLine(int lineNumber) {
        return Integer.toString(lineNumber);
    }
}

