/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.data.Json;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class TestConfigSource
implements ConfigSource {
    public static final String OFFSETS_FILE = "file-connector-offsets.txt";
    public static final Path OFFSET_STORE_PATH = Testing.Files.createTestingPath((String)"file-connector-offsets.txt").toAbsolutePath();
    public static final Path TEST_FILE_PATH = Testing.Files.createTestingPath((String)"file-connector-input.txt").toAbsolutePath();
    final Map<String, String> integrationTest = new HashMap<String, String>();
    final Map<String, String> kinesisTest = new HashMap<String, String>();
    final Map<String, String> pubsubTest = new HashMap<String, String>();
    final Map<String, String> unitTest = new HashMap<String, String>();
    protected Map<String, String> config;

    public TestConfigSource() {
        this.integrationTest.put("debezium.sink.type", "test");
        this.integrationTest.put("debezium.source.connector.class", "io.debezium.connector.postgresql.PostgresConnector");
        this.integrationTest.put("debezium.source.offset.storage.file.filename", OFFSET_STORE_PATH.toAbsolutePath().toString());
        this.integrationTest.put("debezium.source.offset.flush.interval.ms", "0");
        this.integrationTest.put("debezium.source.database.server.name", "testc");
        this.integrationTest.put("debezium.source.schema.include.list", "inventory");
        this.integrationTest.put("debezium.source.table.include.list", "inventory.customers");
        String format = System.getProperty("test.apicurio.converter.format");
        String formatKey = System.getProperty("debezium.format.key");
        String formatValue = System.getProperty("debezium.format.value");
        if (format != null && format.length() != 0) {
            this.integrationTest.put("debezium.format.key", format);
            this.integrationTest.put("debezium.format.value", format);
        } else {
            formatKey = formatKey != null ? formatKey : Json.class.getSimpleName().toLowerCase();
            formatValue = formatValue != null ? formatValue : Json.class.getSimpleName().toLowerCase();
            this.integrationTest.put("debezium.format.key", formatKey);
            this.integrationTest.put("debezium.format.value", formatValue);
        }
        this.unitTest.put("debezium.sink.type", "test");
        this.unitTest.put("debezium.source.connector.class", "org.apache.kafka.connect.file.FileStreamSourceConnector");
        this.unitTest.put("debezium.source.offset.storage.file.filename", OFFSET_STORE_PATH.toAbsolutePath().toString());
        this.unitTest.put("debezium.source.offset.flush.interval.ms", "0");
        this.unitTest.put("debezium.source.file", TEST_FILE_PATH.toAbsolutePath().toString());
        this.unitTest.put("debezium.source.topic", "topicX");
        this.unitTest.put("debezium.format.schemas.enable", "true");
        this.unitTest.put("debezium.format.value.schemas.enable", "false");
        this.unitTest.put("debezium.transforms", "hoist");
        this.unitTest.put("debezium.transforms.hoist.type", "org.apache.kafka.connect.transforms.HoistField$Value");
        this.unitTest.put("debezium.transforms.hoist.field", "line");
        this.unitTest.put("DEBEZIUM_SOURCE_TABLE_INCLUDE_LIST", "public.table_name");
        this.unitTest.put("debezium_source_offset_flush_interval_ms_Test", "0");
        this.unitTest.put("debezium.source.snapshot.select.statement.overrides.public.table_name", "SELECT * FROM table_name WHERE 1>2");
        this.unitTest.put("debezium.source.database.allowPublicKeyRetrieval", "true");
        this.config = TestConfigSource.isItTest() ? this.integrationTest : this.unitTest;
    }

    public static boolean isItTest() {
        return "IT".equals(System.getProperty("test.type"));
    }

    public Map<String, String> getProperties() {
        return this.config;
    }

    public String getValue(String propertyName) {
        return this.config.get(propertyName);
    }

    public String getName() {
        return "test";
    }

    public Set<String> getPropertyNames() {
        return this.config.keySet();
    }

    public static int waitForSeconds() {
        return 60;
    }
}

