/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.util.ClassPathUtils;
import java.io.InputStream;
import java.lang.reflect.Method;

public class ResourceHelper {
    public static void registerResources(String resource) {
        try {
            Class<?> resourcesClass = Class.forName("com.oracle.svm.core.jdk.Resources");
            Method register = resourcesClass.getDeclaredMethod("registerResource", String.class, InputStream.class);
            ClassPathUtils.consumeAsStreams(ResourceHelper.class.getClassLoader(), resource, in -> {
                try {
                    register.invoke(null, resource, in);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to register resource " + resource, e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load resource " + resource, e);
        }
    }
}

