/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableReferenceProvider;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;

public class InjectionPointProvider
implements InjectableReferenceProvider<InjectionPoint> {
    private static final ThreadLocal<InjectionPoint> CURRENT = new ThreadLocal();

    @Override
    public InjectionPoint get(CreationalContext<InjectionPoint> creationalContext) {
        return CURRENT.get();
    }

    static InjectionPoint set(InjectionPoint injectionPoint) {
        if (injectionPoint != null) {
            InjectionPoint prev = CURRENT.get();
            if (injectionPoint.equals(prev)) {
                return injectionPoint;
            }
            CURRENT.set(injectionPoint);
            return prev;
        }
        CURRENT.remove();
        return null;
    }

    public static InjectionPoint get() {
        return CURRENT.get();
    }
}

