/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.NonEmptyListValidator;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public class ValueToKey<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Replace the record key with a new key formed from a subset of fields in the record value.";
    public static final String FIELDS_CONFIG = "fields";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("fields", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "Field names on the record value to extract as the record key.");
    private static final String PURPOSE = "copying fields from value to key";
    private List<String> fields;
    private Cache<Schema, Schema> valueToKeySchemaCache;

    public void configure(Map<String, ?> configs) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, configs);
        this.fields = config.getList(FIELDS_CONFIG);
        this.valueToKeySchemaCache = new SynchronizedCache((Cache)new LRUCache(16));
    }

    public R apply(R record) {
        if (record.valueSchema() == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    private R applySchemaless(R record) {
        Map<String, Object> value = Requirements.requireMap(record.value(), PURPOSE);
        HashMap<String, Object> key = new HashMap<String, Object>(this.fields.size());
        for (String field : this.fields) {
            key.put(field, value.get(field));
        }
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), null, key, record.valueSchema(), record.value(), record.timestamp());
    }

    private R applyWithSchema(R record) {
        Struct value = Requirements.requireStruct(record.value(), PURPOSE);
        Schema keySchema = (Schema)this.valueToKeySchemaCache.get((Object)value.schema());
        if (keySchema == null) {
            SchemaBuilder keySchemaBuilder = SchemaBuilder.struct();
            for (String field : this.fields) {
                Field fieldFromValue = value.schema().field(field);
                if (fieldFromValue == null) {
                    throw new DataException("Field does not exist: " + field);
                }
                keySchemaBuilder.field(field, fieldFromValue.schema());
            }
            keySchema = keySchemaBuilder.build();
            this.valueToKeySchemaCache.put((Object)value.schema(), (Object)keySchema);
        }
        Struct key = new Struct(keySchema);
        for (String field : this.fields) {
            key.put(field, value.get(field));
        }
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), keySchema, (Object)key, value.schema(), (Object)value, record.timestamp());
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
        this.valueToKeySchemaCache = null;
    }
}

