/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpServerResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class HttpServerRequestImpl
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpServerRequestImpl.class);
    private final Http1xServerConnection conn;
    private HttpRequest request;
    private HttpVersion version;
    private HttpMethod method;
    private String rawMethod;
    private String uri;
    private String path;
    private String query;
    private HttpServerResponseImpl response;
    private HttpServerRequestImpl next;
    private Object metric;
    private Handler<Buffer> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private MultiMap params;
    private MultiMap headers;
    private String absoluteURI;
    private Handler<HttpServerFileUpload> uploadHandler;
    private Handler<Void> endHandler;
    private MultiMap attributes;
    private HttpPostRequestDecoder decoder;
    private boolean ended;
    private long bytesRead;
    private InboundBuffer<Object> pending;

    HttpServerRequestImpl(Http1xServerConnection conn, HttpRequest request) {
        this.conn = conn;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpRequest nettyRequest() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(HttpRequest request) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.request = request;
        }
    }

    private InboundBuffer<Object> pendingQueue() {
        if (this.pending == null) {
            this.pending = new InboundBuffer(this.conn.getContext(), 8L);
            this.pending.drainHandler(v -> this.conn.doResume());
            this.pending.handler((E buffer) -> {
                if (buffer == InboundBuffer.END_SENTINEL) {
                    this.onEnd();
                } else {
                    this.onData((Buffer)buffer);
                }
            });
        }
        return this.pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContent(Buffer buffer) {
        InboundBuffer<Object> queue;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            queue = this.pending;
        }
        if (queue != null) {
            if (!queue.write(buffer)) {
                this.conn.doPause();
            }
        } else {
            this.onData(buffer);
        }
    }

    void handleBegin() {
        if (Metrics.METRICS_ENABLED) {
            this.reportRequestBegin();
        }
        this.response = new HttpServerResponseImpl((VertxInternal)this.conn.vertx(), this.conn, this.request, this.metric);
        if (this.conn.handle100ContinueAutomatically) {
            this.check100();
        }
    }

    void enqueue(HttpServerRequestImpl request) {
        HttpServerRequestImpl current = this;
        while (current.next != null) {
            current = current.next;
        }
        current.next = request;
    }

    HttpServerRequestImpl next() {
        return this.next;
    }

    private void reportRequestBegin() {
        if (this.conn.metrics != null) {
            this.metric = this.conn.metrics.requestBegin(this.conn.metric(), this);
        }
    }

    private void check100() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.request)) {
            this.conn.write100Continue();
        }
    }

    Object metric() {
        return this.metric;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.protocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            } else {
                this.sendNotImplementedAndClose();
                throw new IllegalStateException("Unsupported HTTP version: " + nettyVersion);
            }
        }
        return this.version;
    }

    @Override
    public HttpMethod method() {
        if (this.method == null) {
            String sMethod = this.request.method().toString();
            try {
                this.method = HttpMethod.valueOf(sMethod);
            }
            catch (IllegalArgumentException e) {
                this.method = HttpMethod.OTHER;
            }
        }
        return this.method;
    }

    @Override
    public String rawMethod() {
        if (this.rawMethod == null) {
            this.rawMethod = this.request.method().toString();
        }
        return this.rawMethod;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri());
        }
        return this.query;
    }

    @Override
    public @Nullable String host() {
        return this.getHeader((CharSequence)HttpHeaderNames.HOST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesRead() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesRead;
        }
    }

    @Override
    public HttpServerResponseImpl response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            HttpHeaders reqHeaders = this.request.headers();
            this.headers = reqHeaders instanceof MultiMap ? (MultiMap)reqHeaders : new HeadersAdaptor(reqHeaders);
        }
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public MultiMap params() {
        if (this.params == null) {
            this.params = HttpUtils.params(this.uri());
        }
        return this.params;
    }

    @Override
    public String getParam(String paramName) {
        return this.params().get(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.dataHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.pendingQueue().pause();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest fetch(long amount) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.pendingQueue().fetch(amount);
            return this;
        }
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public String scheme() {
        return this.isSSL() ? "https" : "http";
    }

    @Override
    public boolean isSSL() {
        return this.conn.isSsl();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                this.absoluteURI = HttpUtils.absoluteURI(this.conn.getServerOrigin(), this);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Failed to create abs uri", e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket netSocket() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.response.netSocket(this.method() == HttpMethod.CONNECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    @Override
    public MultiMap formAttributes() {
        return this.attributes();
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public ServerWebSocket upgrade() {
        ServerWebSocketImpl ws = this.conn.createWebSocket(this);
        if (ws == null) {
            throw new IllegalStateException("Can't upgrade this request");
        }
        ws.accept();
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkEnded();
            if (expect) {
                if (this.decoder == null) {
                    String contentType = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    if (contentType == null) {
                        throw new IllegalStateException("Request must have a content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartContentType(contentType)) {
                        throw new IllegalStateException("Request must have a valid content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartMethod(this.request.method())) {
                        throw new IllegalStateException("Request method must be one of POST, PUT, PATCH or DELETE to decode a multipart request");
                    }
                    this.decoder = new HttpPostRequestDecoder((HttpDataFactory)new NettyFileUploadDataFactory(this.conn.getContext(), this, () -> this.uploadHandler), this.request);
                }
            } else {
                this.decoder = null;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.decoder != null;
        }
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.ended && (this.pending == null || !this.pending.isPaused() && this.pending.isEmpty());
        }
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onData(Buffer data) {
        Handler<Buffer> handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bytesRead += (long)data.length();
            if (this.decoder != null) {
                try {
                    this.decoder.offer((HttpContent)new DefaultHttpContent(data.getByteBuf()));
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
            }
            handler = this.dataHandler;
        }
        if (handler != null) {
            handler.handle(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd() {
        InboundBuffer<Object> queue;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.ended = true;
            queue = this.pending;
        }
        if (queue != null) {
            queue.write(InboundBuffer.END_SENTINEL);
        } else {
            this.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        Handler<Void> handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.decoder != null) {
                this.endDecode();
            }
            handler = this.endHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDecode() {
        try {
            this.decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (!(data instanceof Attribute)) continue;
                Attribute attr = (Attribute)data;
                try {
                    this.attributes().add(attr.getName(), attr.getValue());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            this.handleException(e);
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
        }
        finally {
            this.decoder.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Handler<Throwable> handler = null;
        HttpServerResponseImpl resp = null;
        InterfaceHttpData upload = null;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (!this.isEnded()) {
                handler = this.exceptionHandler;
                if (this.decoder != null) {
                    upload = this.decoder.currentPartialHttpData();
                }
            }
            if (!this.response.ended()) {
                if (Metrics.METRICS_ENABLED) {
                    this.reportRequestReset();
                }
                resp = this.response;
            }
        }
        if (resp != null) {
            resp.handleException(t);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(t);
        }
        if (handler != null) {
            handler.handle(t);
        }
    }

    private void reportRequestReset() {
        if (this.conn.metrics != null) {
            this.conn.metrics.requestReset(this.metric);
        }
    }

    private void sendNotImplementedAndClose() {
        this.response().setStatusCode(501).end();
        this.response().close();
    }

    private void checkEnded() {
        if (this.isEnded()) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = MultiMap.caseInsensitiveMultiMap();
        }
        return this.attributes;
    }

    private static String urlDecode(String str) {
        return QueryStringDecoder.decodeComponent((String)str, (Charset)CharsetUtil.UTF_8);
    }

    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        return this;
    }

    @Override
    public @Nullable Cookie getCookie(String name) {
        return this.response.cookies().get(name);
    }

    @Override
    public int cookieCount() {
        return this.response.cookies().size();
    }

    @Override
    public Map<String, Cookie> cookieMap() {
        return this.response.cookies();
    }
}

