/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser;

import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataBuilder;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.parser.TextOutputBuilder$WhenMappings;
import com.worldturner.util.JsonKt;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/worldturner/medeia/parser/TextOutputBuilder;", "Lcom/worldturner/medeia/parser/JsonTokenDataBuilder;", "()V", "outputComma", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "stack", "Ljava/util/Deque;", "Lcom/worldturner/medeia/parser/TextOutputBuilder$StructureType;", "consume", "", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "outputBoolean", "b", "outputNull", "outputNumber", "n", "", "", "takeResult", "", "toString", "StructureType", "medeia-validator-core"})
public final class TextOutputBuilder
implements JsonTokenDataBuilder {
    private final Deque<StructureType> stack = new ArrayDeque();
    private StringBuilder result = new StringBuilder();
    private boolean outputComma;

    @Override
    public void consume(@NotNull JsonTokenData token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        if (this.outputComma && !token.getType().getLastStructureToken()) {
            this.result.append(',');
        }
        switch (TextOutputBuilder$WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
            case 1: {
                String string = token.getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                JsonKt.appendJsonString(this.result, string);
                this.result.append(':');
                break;
            }
            case 2: {
                String string = token.getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                JsonKt.appendJsonString(this.result, string);
                break;
            }
            case 3: {
                this.outputNull();
                break;
            }
            case 4: 
            case 5: {
                this.outputBoolean(token.toBoolean());
                break;
            }
            case 6: {
                if (token.hasLongValue()) {
                    this.outputNumber(token.getLongValue());
                    break;
                }
                BigInteger bigInteger = token.getInteger();
                if (bigInteger != null) {
                    BigInteger bigInteger2;
                    BigInteger it = bigInteger2 = bigInteger;
                    boolean bl = false;
                    this.outputNumber(it);
                    break;
                }
                BigDecimal bigDecimal = token.getDecimal();
                if (bigDecimal != null) {
                    BigDecimal bigDecimal2;
                    BigDecimal it = bigDecimal2 = bigDecimal;
                    boolean bl = false;
                    this.outputNumber(it);
                }
                break;
            }
            case 7: {
                this.result.append('[');
                this.stack.push(StructureType.ARRAY);
                break;
            }
            case 8: {
                this.result.append(']');
                this.stack.pop();
                break;
            }
            case 9: {
                this.result.append('{');
                this.stack.push(StructureType.OBJECT);
                break;
            }
            case 10: {
                this.result.append('}');
                this.stack.pop();
            }
        }
        this.outputComma = !token.getType().getFirstStructureToken() && token.getType() != JsonTokenType.FIELD_NAME;
    }

    public final void outputNumber(long n) {
        this.result.append(n);
    }

    public final void outputNumber(@NotNull Number n) {
        Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
        this.result.append(n);
    }

    public final void outputBoolean(boolean b) {
        this.result.append(b);
    }

    public final void outputNull() {
        this.result.append("null");
    }

    @Override
    @NotNull
    public String takeResult() {
        String string;
        String it = string = this.result.toString();
        boolean bl = false;
        StringsKt.clear((StringBuilder)this.result);
        String string2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString().also { result.clear() }");
        return string2;
    }

    @NotNull
    public String toString() {
        return this.takeResult();
    }

    @Override
    public void consume(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        JsonTokenDataBuilder.DefaultImpls.consume(this, token, location);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/worldturner/medeia/parser/TextOutputBuilder$StructureType;", "", "(Ljava/lang/String;I)V", "ARRAY", "OBJECT", "medeia-validator-core"})
    public static final class StructureType
    extends Enum<StructureType> {
        public static final /* enum */ StructureType ARRAY;
        public static final /* enum */ StructureType OBJECT;
        private static final /* synthetic */ StructureType[] $VALUES;

        static {
            StructureType[] structureTypeArray = new StructureType[2];
            StructureType[] structureTypeArray2 = structureTypeArray;
            structureTypeArray[0] = ARRAY = new StructureType();
            structureTypeArray[1] = OBJECT = new StructureType();
            $VALUES = structureTypeArray;
        }

        public static StructureType[] values() {
            return (StructureType[])$VALUES.clone();
        }

        public static StructureType valueOf(String string) {
            return Enum.valueOf(StructureType.class, string);
        }
    }
}

