/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Consumer;

public class UniOnSubscribeInvoke<T>
extends UniOperator<T, T> {
    private final Consumer<? super UniSubscription> callback;

    public UniOnSubscribeInvoke(Uni<? extends T> upstream, Consumer<? super UniSubscription> callback) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.callback = callback;
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                try {
                    UniOnSubscribeInvoke.this.callback.accept(subscription);
                }
                catch (Throwable e) {
                    super.onSubscribe(EmptyUniSubscription.CANCELLED);
                    super.onFailure(e);
                    return;
                }
                super.onSubscribe(subscription);
            }
        });
    }
}

