/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client.request;

import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeadersInterceptor
implements Interceptor {
    private final Map<String, String> headers;

    public HeadersInterceptor(Map<String, String> headers) {
        this.headers = headers;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Headers requestHeaders = request.headers().newBuilder().addAll(Headers.of(this.headers)).build();
        Request requestWithHeathers = request.newBuilder().headers(requestHeaders).build();
        return chain.proceed(requestWithHeathers);
    }
}

