/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.utils.serde.AvroEncoding;
import io.apicurio.registry.utils.serde.avro.AvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.AvroSchemaUtils;
import io.apicurio.registry.utils.serde.avro.DefaultAvroDatumProvider;
import io.apicurio.registry.utils.serde.util.HeaderUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.header.Headers;

public class AvroKafkaDeserializer<U>
extends AbstractKafkaDeserializer<Schema, U, AvroKafkaDeserializer<U>> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    private AvroDatumProvider<U> avroDatumProvider;
    private AvroEncoding configEncoding;

    public AvroKafkaDeserializer() {
        this(null);
    }

    public AvroKafkaDeserializer(RegistryService client) {
        this(client, new DefaultAvroDatumProvider());
    }

    public AvroKafkaDeserializer(RegistryService client, AvroDatumProvider<U> avroDatumProvider) {
        super(client);
        this.setAvroDatumProvider(avroDatumProvider);
    }

    public AvroKafkaDeserializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        this.configEncoding = AvroEncoding.fromConfig(configs);
        this.headerUtils = new HeaderUtils(configs, isKey);
        Object adp = configs.get("apicurio.registry.avro-datum-provider");
        Consumer<AvroDatumProvider> consumer = this::setAvroDatumProvider;
        this.instantiate(AvroDatumProvider.class, adp, consumer);
        this.avroDatumProvider.configure(configs);
    }

    @Override
    protected Schema toSchema(Response response) {
        Object responseEntity = response.getEntity();
        if (responseEntity instanceof InputStream) {
            return AvroSchemaUtils.parse(IoUtil.toString((InputStream)((InputStream)responseEntity)));
        }
        return AvroSchemaUtils.parse((String)response.readEntity(String.class));
    }

    @Override
    protected U readData(Schema schema, ByteBuffer buffer, int start, int length) {
        return this.readData((Headers)null, schema, buffer, start, length);
    }

    @Override
    protected U readData(Headers headers, Schema schema, ByteBuffer buffer, int start, int length) {
        AvroEncoding encoding = null;
        if (headers != null && this.headerUtils != null) {
            encoding = this.headerUtils.getEncoding(headers);
        }
        if (encoding == null) {
            encoding = this.configEncoding;
        }
        try {
            DatumReader<U> reader = this.avroDatumProvider.createDatumReader(schema);
            if (encoding == AvroEncoding.JSON) {
                byte[] msgData = new byte[length];
                System.arraycopy(buffer.array(), start, msgData, 0, length);
                return (U)reader.read(null, (Decoder)this.decoderFactory.jsonDecoder(schema, (InputStream)new ByteArrayInputStream(msgData)));
            }
            return (U)reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

