/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.server.DebeziumServer;
import io.debezium.server.TestConfigSource;
import io.debezium.server.TestConsumer;
import io.debezium.server.events.ConnectorCompletedEvent;
import io.debezium.server.events.ConnectorStartedEvent;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.file.Path;
import java.time.Duration;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

@QuarkusTest
@QuarkusTestResource(value=PostgresTestResourceLifecycleManager.class)
@EnabledIfSystemProperty(named="test.apicurio", matches="false", disabledReason="DebeziumServerIT doesn't run with apicurio profile.")
public class DebeziumServerIT {
    private static final int MESSAGE_COUNT = 4;
    @Inject
    DebeziumServer server;

    public DebeziumServerIT() {
        Testing.Files.delete((Path)TestConfigSource.OFFSET_STORE_PATH);
    }

    void setupDependencies(@Observes ConnectorStartedEvent event) {
        if (!TestConfigSource.isItTest()) {
            return;
        }
    }

    void connectorCompleted(@Observes ConnectorCompletedEvent event) throws Exception {
        if (!event.isSuccess()) {
            throw (Exception)event.getError().get();
        }
    }

    @Test
    public void testPostgres() throws Exception {
        Testing.Print.enable();
        TestConsumer testConsumer = (TestConsumer)this.server.getConsumer();
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> testConsumer.getValues().size() >= 4);
        Assertions.assertThat((int)testConsumer.getValues().size()).isEqualTo(4);
        Assertions.assertThat((String)((String)testConsumer.getValues().get(3))).contains("\"after\":{\"id\":1004,\"first_name\":\"Anne\",\"last_name\":\"Kretchmar\",\"email\":\"annek@noanswer.org\"}");
    }
}

