/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class UniFailOnTimeout<I>
extends UniOperator<I, I> {
    private final Duration timeout;
    private final Supplier<? extends Throwable> supplier;
    private final ScheduledExecutorService executor;

    public UniFailOnTimeout(Uni<I> upstream, Duration timeout, Supplier<? extends Throwable> supplier, ScheduledExecutorService executor) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.timeout = ParameterValidation.validate(timeout, "onTimeout");
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
        this.executor = executor == null ? Infrastructure.getDefaultWorkerPool() : executor;
    }

    @Override
    protected void subscribing(final UniSubscriber<? super I> subscriber) {
        final AtomicBoolean doneOrCancelled = new AtomicBoolean();
        final AtomicReference task = new AtomicReference();
        AbstractUni.subscribe(this.upstream(), new UniSubscriber<I>(){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                try {
                    task.set(UniFailOnTimeout.this.executor.schedule(() -> {
                        if (doneOrCancelled.compareAndSet(false, true)) {
                            UniFailOnTimeout.this.sendTimeout(subscriber, subscription);
                        }
                    }, UniFailOnTimeout.this.timeout.toMillis(), TimeUnit.MILLISECONDS));
                }
                catch (RejectedExecutionException e) {
                    subscriber.onSubscribe(Subscriptions.CANCELLED);
                    subscriber.onFailure(e);
                    return;
                }
                subscriber.onSubscribe(() -> {
                    if (doneOrCancelled.compareAndSet(false, true)) {
                        subscription.cancel();
                        ScheduledFuture future = task.getAndSet(null);
                        if (future != null) {
                            future.cancel(false);
                        }
                    }
                });
            }

            @Override
            public void onItem(I item) {
                if (doneOrCancelled.compareAndSet(false, true)) {
                    ScheduledFuture future = task.getAndSet(null);
                    if (future != null) {
                        future.cancel(false);
                    }
                    subscriber.onItem(item);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (doneOrCancelled.compareAndSet(false, true)) {
                    ScheduledFuture future = task.getAndSet(null);
                    if (future != null) {
                        future.cancel(false);
                    }
                    subscriber.onFailure(failure);
                } else {
                    Infrastructure.handleDroppedException(failure);
                }
            }
        });
    }

    private void sendTimeout(UniSubscriber<? super I> subscriber, UniSubscription subscription) {
        Throwable throwable;
        subscription.cancel();
        try {
            throwable = this.supplier.get();
        }
        catch (Throwable e) {
            subscriber.onFailure(e);
            return;
        }
        if (throwable == null) {
            subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
        } else {
            subscriber.onFailure(throwable);
        }
    }
}

