/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.threads.EnhancedQueueExecutor;
import sun.misc.Unsafe;

public final class CleanableExecutor
implements ExecutorService {
    private final EnhancedQueueExecutor executor;
    private static final AtomicInteger generation;
    private static final ThreadLocal<Integer> lastGeneration;
    static final Unsafe unsafe;

    public CleanableExecutor(EnhancedQueueExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Resetter.run();
        generation.incrementAndGet();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable empty = new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        try {
            if (!this.executor.isShutdown()) {
                for (int i = 0; i < this.executor.getMaximumPoolSize(); ++i) {
                    try {
                        this.submit(empty);
                        continue;
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            latch.countDown();
        }
    }

    private static void handleClean(int taskGen) {
        int val = lastGeneration.get();
        if (val == -1) {
            lastGeneration.set(taskGen);
        } else if (val != taskGen) {
            Resetter.run();
            lastGeneration.set(taskGen);
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(new CleaningCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit((Runnable)new CleaningRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit((Runnable)new CleaningRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable<T>> submit = this.createWrappedList(tasks);
        return this.executor.invokeAll(submit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable<T>> submit = this.createWrappedList(tasks);
        return this.executor.invokeAll(submit, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList<Callable<T>> submit = this.createWrappedList(tasks);
        return (T)this.executor.invokeAny(submit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Callable<T>> submit = this.createWrappedList(tasks);
        return (T)this.executor.invokeAny(submit, timeout, unit);
    }

    private <T> ArrayList<Callable<T>> createWrappedList(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> submit = new ArrayList<Callable<T>>();
        for (Callable<T> i : tasks) {
            submit.add(new CleaningCallable<T>(i));
        }
        return submit;
    }

    @Override
    public void execute(Runnable command) {
        this.executor.submit((Runnable)new CleaningRunnable(command));
    }

    static /* synthetic */ AtomicInteger access$000() {
        return generation;
    }

    static {
        try {
            Class.forName("org.jboss.threads.EnhancedQueueExecutor$1", false, CleanableExecutor.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        generation = new AtomicInteger(1);
        lastGeneration = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return -1;
            }
        };
        unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

            @Override
            public Unsafe run() {
                try {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
            }
        });
    }

    private static class CleaningCallable<T>
    implements Callable<T> {
        private final Callable<T> i;
        final int gen = CleanableExecutor.access$000().get();

        public CleaningCallable(Callable<T> i) {
            this.i = i;
        }

        @Override
        public T call() throws Exception {
            CleanableExecutor.handleClean(this.gen);
            return this.i.call();
        }
    }

    private static class CleaningRunnable
    implements Runnable {
        private final Runnable command;
        final int gen = CleanableExecutor.access$000().get();

        public CleaningRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            CleanableExecutor.handleClean(this.gen);
            this.command.run();
        }
    }

    static final class Resetter {
        private static final long threadLocalMapOffs;
        private static final long inheritableThreadLocalMapOffs;

        Resetter() {
        }

        static void run() {
            Thread thread = Thread.currentThread();
            unsafe.putObject(thread, threadLocalMapOffs, null);
            unsafe.putObject(thread, inheritableThreadLocalMapOffs, null);
        }

        static {
            try {
                threadLocalMapOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
                inheritableThreadLocalMapOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    }
}

