/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;

public class UniMemoizeOp<I>
extends UniOperator<I, I>
implements UniSubscriber<I> {
    private final BooleanSupplier invalidationRequested;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AtomicInteger wip = new AtomicInteger();
    private final List<UniSubscriber<? super I>> awaitingSubscription = Collections.synchronizedList(new ArrayList());
    private final List<UniSubscriber<? super I>> awaitingResult = Collections.synchronizedList(new ArrayList());
    private volatile UniSubscription upstreamSubscription;
    private volatile I item;
    private volatile Throwable failure;

    public UniMemoizeOp(Uni<? extends I> upstream) {
        this(upstream, () -> false);
    }

    public UniMemoizeOp(Uni<? extends I> upstream, BooleanSupplier invalidationRequested) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.invalidationRequested = invalidationRequested;
    }

    @Override
    protected void subscribing(UniSubscriber<? super I> subscriber) {
        if (this.invalidationRequested.getAsBoolean() && this.state.get() != State.SUBSCRIBING) {
            this.state.set(State.INIT);
            if (this.upstreamSubscription != null) {
                this.upstreamSubscription.cancel();
            }
        }
        if (this.state.get() == State.CACHING) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            if (this.failure != null) {
                subscriber.onFailure(this.failure);
            } else {
                subscriber.onItem(this.item);
            }
            return;
        }
        this.awaitingSubscription.add(subscriber);
        if (this.state.compareAndSet(State.INIT, State.SUBSCRIBING)) {
            AbstractUni.subscribe(this.upstream(), this);
        }
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        if (this.state.compareAndSet(State.SUBSCRIBING, State.SUBSCRIBED)) {
            this.upstreamSubscription = subscription;
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            Throwable currentFailure;
            I currentItem;
            ArrayList<UniSubscriber<I>> subscribers;
            Iterator<UniSubscriber<I>> iterator;
            if (!this.awaitingSubscription.isEmpty()) {
                iterator = this.awaitingSubscription;
                synchronized (iterator) {
                    subscribers = new ArrayList<UniSubscriber<I>>(this.awaitingSubscription);
                }
                block12: for (UniSubscriber<I> subscriber : subscribers) {
                    currentItem = this.item;
                    currentFailure = this.failure;
                    State state = this.state.get();
                    switch (state) {
                        case INIT: 
                        case SUBSCRIBING: {
                            continue block12;
                        }
                        case SUBSCRIBED: {
                            subscriber.onSubscribe(() -> this.removeFromAwaitingLists(subscriber));
                            this.awaitingSubscription.remove(subscriber);
                            this.awaitingResult.add(subscriber);
                            continue block12;
                        }
                        case CACHING: {
                            subscriber.onSubscribe(() -> this.removeFromAwaitingLists(subscriber));
                            if (currentFailure != null) {
                                subscriber.onFailure(currentFailure);
                            } else {
                                subscriber.onItem(currentItem);
                            }
                            this.awaitingSubscription.remove(subscriber);
                            this.awaitingResult.remove(subscriber);
                            continue block12;
                        }
                    }
                    throw new IllegalStateException("Current state is " + (Object)((Object)state));
                }
            }
            if (this.awaitingResult.isEmpty()) continue;
            iterator = this.awaitingResult;
            synchronized (iterator) {
                subscribers = new ArrayList<UniSubscriber<I>>(this.awaitingResult);
            }
            for (UniSubscriber<I> subscriber : subscribers) {
                currentItem = this.item;
                currentFailure = this.failure;
                if (this.state.get() != State.CACHING) continue;
                if (this.failure != null) {
                    subscriber.onFailure(currentFailure);
                } else {
                    subscriber.onItem(currentItem);
                }
                this.awaitingResult.remove(subscriber);
            }
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    private void removeFromAwaitingLists(UniSubscriber<? super I> subscriber) {
        this.awaitingSubscription.remove(subscriber);
        this.awaitingResult.remove(subscriber);
        this.drain();
    }

    @Override
    public void onItem(I item) {
        if (this.state.get() == State.SUBSCRIBED) {
            this.item = item;
            this.failure = null;
            this.state.set(State.CACHING);
            this.drain();
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        if (this.state.get() == State.SUBSCRIBED) {
            this.item = null;
            this.failure = failure;
            this.state.set(State.CACHING);
            this.drain();
        }
    }

    private static enum State {
        INIT,
        SUBSCRIBING,
        SUBSCRIBED,
        CACHING;

    }
}

