/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class TestDatabase {
    public static final String POSTGRES_USER = "postgres";
    public static final String POSTGRES_PASSWORD = "postgres";
    public static final String POSTGRES_DBNAME = "postgres";
    public static final String POSTGRES_IMAGE = "debezium/example-postgres";
    public static final String POSTGRES_HOST = "localhost";
    public static final Integer POSTGRES_PORT = 5432;
    private GenericContainer container;

    public void start() {
        try {
            this.container = new FixedHostPortGenericContainer(POSTGRES_IMAGE).withFixedExposedPort(POSTGRES_PORT.intValue(), POSTGRES_PORT.intValue()).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*database system is ready to accept connections.*", (int)2)).withEnv("POSTGRES_USER", "postgres").withEnv("POSTGRES_PASSWORD", "postgres").withEnv("POSTGRES_DB", "postgres").withEnv("POSTGRES_INITDB_ARGS", "-E UTF8").withEnv("LANG", "en_US.utf8").withStartupTimeout(Duration.ofSeconds(30L));
            this.container.start();
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    public String getIp() {
        return POSTGRES_HOST;
    }

    public int getPort() {
        return POSTGRES_PORT;
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

