/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.DebeziumException;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.transforms.Module;
import io.debezium.transforms.scripting.Engine;
import io.debezium.transforms.scripting.GraalJsEngine;
import io.debezium.transforms.scripting.Jsr223Engine;
import io.debezium.util.Strings;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public abstract class ScriptingTransformation<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String JAVAX_SCRIPT_ENGINE_PREFIX = "jsr223.";
    private static final String GRAAL_JS_ENGINE = "graal.js";
    private static final Field TOPIC_REGEX = Field.create((String)"topic.regex").withDisplayName("Topic regex").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isRegex}).withDescription("A regex used for selecting the topic(s) to which this transformation should be applied.");
    public static final Field LANGUAGE = Field.create((String)"language").withDisplayName("Expression language").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).required().withDescription("An expression language used to evaluate the expression. Must begin with 'jsr223.', e.g.  'jsr223.groovy' or 'jsr223.graal.js'.");
    public static final Field NULL_HANDLING = Field.create((String)"null.handling.mode").withDisplayName("Handle null records").withEnum(NullHandling.class, (Enum)NullHandling.KEEP).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("How to handle records with null value. Options are: keep - records are passed (the default),drop - records are removed,evaluate - the null records are passed for evaluation.");
    protected Engine engine;
    private NullHandling nullHandling;
    private Pattern topicPattern;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        Field.Set configFields = Field.setOf((Field[])new Field[]{TOPIC_REGEX, LANGUAGE, this.expressionField(), NULL_HANDLING});
        if (!config.validateAndRecord((Iterable)configFields, arg_0 -> ((Logger)this.LOGGER).error(arg_0))) {
            throw new DebeziumException("The provided configuration isn't valid; check the error log for details.");
        }
        String expression = config.getString(this.expressionField());
        String language = config.getString(LANGUAGE);
        this.LOGGER.info("Using language '{}' to evaluate expression '{}'", (Object)language, (Object)expression);
        if (!language.startsWith(JAVAX_SCRIPT_ENGINE_PREFIX)) {
            throw new DebeziumException("Value for option '" + LANGUAGE + "' must begin with 'jsr223.', e.g. 'jsr223.groovy'");
        }
        this.engine = (language = language.substring(JAVAX_SCRIPT_ENGINE_PREFIX.length())).equals(GRAAL_JS_ENGINE) ? new GraalJsEngine() : new Jsr223Engine();
        try {
            this.engine.configure(language, expression);
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to parse expression '" + expression + "'", (Throwable)e);
        }
        this.nullHandling = NullHandling.parse(config.getString(NULL_HANDLING));
        String topicRegex = config.getString(TOPIC_REGEX);
        if (!Strings.isNullOrEmpty((String)topicRegex)) {
            this.topicPattern = Pattern.compile(topicRegex);
        }
    }

    public R apply(R record) {
        if (this.topicPattern != null && !this.topicPattern.matcher(record.topic()).matches()) {
            return record;
        }
        if (record.value() == null) {
            if (this.nullHandling == NullHandling.KEEP) {
                return record;
            }
            if (this.nullHandling == NullHandling.DROP) {
                return null;
            }
        }
        return this.doApply(record);
    }

    protected abstract R doApply(R var1);

    protected abstract Field expressionField();

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, null, (Field[])new Field[]{TOPIC_REGEX, LANGUAGE, this.expressionField(), NULL_HANDLING});
        return config;
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }

    public static enum NullHandling implements EnumeratedValue
    {
        DROP("drop"),
        KEEP("keep"),
        EVALUATE("evaluate");

        private final String value;

        private NullHandling(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static NullHandling parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (NullHandling option : NullHandling.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static NullHandling parse(String value, String defaultValue) {
            NullHandling mode = NullHandling.parse(value);
            if (mode == null && defaultValue != null) {
                mode = NullHandling.parse(defaultValue);
            }
            return mode;
        }
    }
}

