/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.DebeziumException;
import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.transforms.ContentBasedRouter;
import java.time.Instant;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.StringAssert;
import org.junit.Test;

public class RouterTest {
    private static final String TOPIC_REGEX = "topic.regex";
    private static final String LANGUAGE = "language";
    private static final String EXPRESSION = "topic.expression";
    private static final String NULL_HANDLING = "null.handling.mode";
    final Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).field("name", (Schema)SchemaBuilder.string()).build();
    final Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).build();
    final Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();

    @Test(expected=DebeziumException.class)
    public void testExpressionRequired() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
        }
    }

    @Test(expected=DebeziumException.class)
    public void shouldFailOnInvalidReturnValue() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "1");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            transform.apply((ConnectRecord)this.createDeleteRecord(1));
        }
    }

    @Test
    public void shouldRoute() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value == null ? 'nulls' : (value.before.id == 1 ? 'ones' : null)");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)this.createDeleteRecord(1))).topic()).isEqualTo((Object)"ones");
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)this.createDeleteRecord(2))).topic()).isEqualTo((Object)"original");
        }
    }

    @Test
    public void shouldRouteMongoDbFormat() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value == null ? 'nulls' : ((new groovy.json.JsonSlurper()).parseText(value.after).last_name == 'Kretchmar' ? 'kretchmar' : null)");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)this.createMongoDbRecord())).topic()).isEqualTo((Object)"kretchmar");
        }
    }

    @Test
    @FixFor(value={"DBZ-2024"})
    public void shouldApplyTopicRegex() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(TOPIC_REGEX, "orig.*");
            props.put(EXPRESSION, "value == null ? 'nulls' : (value.before.id == 1 ? 'ones' : null)");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            ((StringAssert)Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)this.createDeleteRecord(1))).topic()).describedAs("Matching topic")).isEqualTo((Object)"ones");
            ((StringAssert)Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)this.createDeleteCustomerRecord(1))).topic()).describedAs("Non-matching topic")).isEqualTo((Object)"customer");
        }
    }

    @Test
    public void shouldKeepNulls() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value == null ? 'nulls' : (value.before.id == 1 ? 'ones' : null)");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            SourceRecord record = this.createNullRecord();
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)record)).topic()).isEqualTo((Object)"original");
        }
    }

    @Test
    public void shouldDropNulls() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value == null ? 'nulls' : (value.before.id == 1 ? 'ones' : null)");
            props.put(LANGUAGE, "jsr223.groovy");
            props.put(NULL_HANDLING, "drop");
            transform.configure(props);
            SourceRecord record = this.createNullRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)record)).isNull();
        }
    }

    @Test
    public void shouldEvaluateNulls() {
        try (ContentBasedRouter transform = new ContentBasedRouter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value == null ? 'nulls' : (value.before.id == 1 ? 'ones' : null)");
            props.put(LANGUAGE, "jsr223.groovy");
            props.put(NULL_HANDLING, "evaluate");
            transform.configure(props);
            SourceRecord record = this.createNullRecord();
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)record)).topic()).isEqualTo((Object)"nulls");
        }
    }

    private SourceRecord createDeleteRecord(int id) {
        Schema deleteSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope deleteEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(deleteSourceSchema).build();
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(deleteSourceSchema);
        before.put("id", (Object)((byte)id));
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = deleteEnvelope.delete((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "original", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createMongoDbRecord() {
        Schema insertSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope insertEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(Schema.STRING_SCHEMA).withSource(insertSourceSchema).build();
        Struct source = new Struct(insertSourceSchema);
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = insertEnvelope.create((Object)"{\"_id\": {\"$numberLong\": \"1004\"},\"first_name\": \"Anne\",\"last_name\": \"Kretchmar\",\"email\": \"annek@noanswer.org\"}", source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "original", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createDeleteCustomerRecord(int id) {
        Schema deleteSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope deleteEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(deleteSourceSchema).build();
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(deleteSourceSchema);
        before.put("id", (Object)((byte)id));
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = deleteEnvelope.delete((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "customer", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createNullRecord() {
        return new SourceRecord(new HashMap(), new HashMap(), "original", null, null, null, null);
    }
}

