/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schemagenerator.maven;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Charsets;
import io.debezium.DebeziumException;
import io.debezium.schemagenerator.SchemaGenerator;
import io.smallrye.openapi.runtime.io.Format;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.DotName;

@Mojo(name="generate-api-spec", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class SchemaGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="openapi", property="schema.format")
    private String format;
    @Parameter(defaultValue="${project.build.directory}/generated-sources", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String classPath = this.getClassPath();
        try {
            int result = this.exec(SchemaGenerator.class.getName(), classPath, Collections.emptyList(), Arrays.asList(this.format, this.outputDirectory.getAbsolutePath()));
            if (result != 0) {
                throw new MojoExecutionException("Couldn't generate API spec; please see the logs for more details");
            }
            this.getLog().info((CharSequence)("Generated API spec at " + this.outputDirectory.getAbsolutePath()));
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Couldn't generate API spec", e);
        }
    }

    private int exec(String className, String classPath, List<String> jvmArgs, List<String> args) throws IOException, InterruptedException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.addAll(jvmArgs);
        command.add("-cp");
        command.add(classPath);
        command.add(className);
        command.addAll(args);
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = builder.inheritIO().start();
        process.waitFor();
        return process.exitValue();
    }

    private String getClassPath() {
        Set artifacts = this.project.getDependencyArtifacts();
        Object classPath = artifacts.stream().filter(a -> a.getScope().equals("compile") || a.getScope().equals("provided")).map(a -> a.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        classPath = (String)classPath + this.classPathEntryFor(((Object)((Object)this)).getClass());
        classPath = (String)classPath + this.classPathEntryFor(OpenAPI.class);
        classPath = (String)classPath + this.classPathEntryFor(ConfigDef.class);
        classPath = (String)classPath + this.classPathEntryFor(Format.class);
        classPath = (String)classPath + this.classPathEntryFor(DebeziumException.class);
        classPath = (String)classPath + this.classPathEntryFor(JsonProcessingException.class);
        classPath = (String)classPath + this.classPathEntryFor(YAMLFactory.class);
        classPath = (String)classPath + this.classPathEntryFor(JsonNode.class);
        classPath = (String)classPath + this.classPathEntryFor(JsonView.class);
        classPath = (String)classPath + this.classPathEntryFor(DotName.class);
        classPath = (String)classPath + this.classPathEntryFor(Charsets.class);
        classPath = (String)classPath + File.pathSeparator + this.project.getArtifact().getFile().getAbsolutePath();
        return classPath;
    }

    private String classPathEntryFor(Class<?> clazz) {
        return File.pathSeparator + clazz.getProtectionDomain().getCodeSource().getLocation().toString();
    }
}

