/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schemagenerator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import io.debezium.metadata.ConnectorMetadata;
import io.debezium.metadata.ConnectorMetadataProvider;
import io.debezium.schemagenerator.JsonSchemaCreatorService;
import io.debezium.schemagenerator.formats.ApiFormat;
import io.debezium.schemagenerator.formats.ApiFormatName;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class OpenApiGenerator {
    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: OpenApiGenerator <format-name> <output-directory>");
        }
        String formatName = args[0].trim();
        Path outputDirectory = new File(args[1]).toPath();
        new OpenApiGenerator().run(formatName, outputDirectory);
    }

    private void run(String formatName, Path outputDirectory) {
        List<ConnectorMetadata> allMetadata = this.getMetadata();
        ApiFormat format = this.getApiFormat(formatName);
        for (ConnectorMetadata connectorMetadata : allMetadata) {
            JsonSchemaCreatorService jsonSchemaCreatorService = new JsonSchemaCreatorService(connectorMetadata, format.getFieldFilter());
            Schema buildConnectorSchema = jsonSchemaCreatorService.buildConnectorSchema();
            String spec = format.getSpec(buildConnectorSchema);
            try {
                Files.write((byte[])spec.getBytes(Charsets.UTF_8), (File)outputDirectory.resolve(connectorMetadata.getConnectorDescriptor().getId() + ".json").toFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't write file", e);
            }
        }
    }

    private List<ConnectorMetadata> getMetadata() {
        ServiceLoader<ConnectorMetadataProvider> metadataProviders = ServiceLoader.load(ConnectorMetadataProvider.class);
        return metadataProviders.stream().map(p -> ((ConnectorMetadataProvider)p.get()).getConnectorMetadata()).collect(Collectors.toList());
    }

    private ApiFormat getApiFormat(String formatName) {
        Optional<ServiceLoader.Provider> format = ServiceLoader.load(ApiFormat.class).stream().filter(p -> p.type().getAnnotation(ApiFormatName.class).value().equals(formatName)).findFirst();
        return (ApiFormat)format.orElseThrow().get();
    }
}

