/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.AbstractEventDispatcher;
import io.debezium.outbox.quarkus.internal.DebeziumTextMap;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DebeziumTracerEventDispatcher
extends AbstractEventDispatcher {
    public static final String TRACING_SPAN_CONTEXT = "tracingspancontext";
    private static final String OPERATION_NAME = "outbox-write";
    private static final String TRACING_COMPONENT = "debezium";
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumTracerEventDispatcher.class);
    @Inject
    Tracer tracer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExportedEvent(@Observes ExportedEvent<?, ?> event) {
        LOGGER.debug("An exported event was found for type {}", (Object)event.getType());
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(OPERATION_NAME);
        DebeziumTextMap exportedSpanData = new DebeziumTextMap();
        Span parentSpan = this.tracer.activeSpan();
        if (parentSpan != null) {
            spanBuilder.asChildOf(parentSpan);
        }
        spanBuilder.withTag("aggregateType", event.getAggregateType()).withTag("aggregateId", event.getAggregateId().toString()).withTag("type", event.getAggregateType()).withTag("timestamp", event.getTimestamp().toString());
        Span activeSpan = spanBuilder.start();
        try (Scope outboxSpanScope = this.tracer.scopeManager().activate(activeSpan);){
            Tags.COMPONENT.set(activeSpan, TRACING_COMPONENT);
            this.tracer.inject(activeSpan.context(), Format.Builtin.TEXT_MAP, (Object)exportedSpanData);
            Map<String, Object> dataMap = this.getDataMapFromEvent(event);
            dataMap.put(TRACING_SPAN_CONTEXT, exportedSpanData.export());
            this.persist(dataMap);
        }
        finally {
            activeSpan.finish();
        }
    }
}

