/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.persistence.AttributeConverter;
import org.hibernate.HibernateException;

public class JsonNodeAttributeConverter
implements AttributeConverter<JsonNode, String> {
    private static final ObjectMapper mapper = new ObjectMapper();

    public String convertToDatabaseColumn(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        try {
            return mapper.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException("Failed to convert JsonNode to String", (Throwable)e);
        }
    }

    public JsonNode convertToEntityAttribute(String databaseValue) {
        if (databaseValue == null) {
            return null;
        }
        try {
            return (JsonNode)mapper.readValue(databaseValue, JsonNode.class);
        }
        catch (IOException e) {
            throw new HibernateException("Failed to convert String to JsonNode", (Throwable)e);
        }
    }
}

