/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.DebeziumOutboxRuntimeConfig;
import io.debezium.outbox.quarkus.internal.EventDispatcher;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hibernate.Session;

public abstract class AbstractEventDispatcher
implements EventDispatcher {
    protected static final String TIMESTAMP = "timestamp";
    protected static final String PAYLOAD = "payload";
    protected static final String TYPE = "type";
    protected static final String AGGREGATE_ID = "aggregateId";
    protected static final String AGGREGATE_TYPE = "aggregateType";
    @Inject
    EntityManager entityManager;
    @Inject
    DebeziumOutboxRuntimeConfig config;

    protected void persist(Map<String, Object> dataMap) {
        Session session = (Session)this.entityManager.unwrap(Session.class);
        session.save("io.debezium.outbox.quarkus.internal.OutboxEvent", dataMap);
        session.setReadOnly(dataMap, true);
        if (this.config.removeAfterInsert) {
            session.delete("io.debezium.outbox.quarkus.internal.OutboxEvent", dataMap);
        }
    }

    protected Map<String, Object> getDataMapFromEvent(ExportedEvent<?, ?> event) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(AGGREGATE_TYPE, event.getAggregateType());
        dataMap.put(AGGREGATE_ID, event.getAggregateId());
        dataMap.put(TYPE, event.getType());
        dataMap.put(PAYLOAD, event.getPayload());
        dataMap.put(TIMESTAMP, event.getTimestamp());
        return dataMap;
    }
}

