/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.DebeziumOutboxRuntimeConfig;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
    @Inject
    EntityManager entityManager;
    DebeziumOutboxRuntimeConfig config;

    public void setOutboxRuntimeProperties(DebeziumOutboxRuntimeConfig outboxRuntimeProperties) {
        this.config = outboxRuntimeProperties;
    }

    public void onExportedEvent(@Observes ExportedEvent<?, ?> event) {
        LOGGER.debug("An exported event was found for type {}", (Object)event.getType());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("aggregateType", event.getAggregateType());
        dataMap.put("aggregateId", event.getAggregateId());
        dataMap.put("type", event.getType());
        dataMap.put("payload", event.getPayload());
        dataMap.put("timestamp", event.getTimestamp());
        Session session = (Session)this.entityManager.unwrap(Session.class);
        session.save("io.debezium.outbox.quarkus.internal.OutboxEvent", dataMap);
        if (this.config.removeAfterInsert) {
            session.delete("io.debezium.outbox.quarkus.internal.OutboxEvent", dataMap);
        }
    }
}

