/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.reactive.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.DebeziumTextMap;
import io.debezium.outbox.reactive.quarkus.DebeziumCustomCodec;
import io.debezium.outbox.reactive.quarkus.internal.AbstractEventDispatcher;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.quarkus.vertx.ConsumeEvent;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DebeziumTracerEventDispatcher
extends AbstractEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumTracerEventDispatcher.class);
    private static final String OPERATION_NAME = "outbox-write";
    private static final String TRACING_COMPONENT = "debezium";
    @Inject
    Tracer tracer;

    @Override
    @ConsumeEvent(value="debezium-outbox", codec=DebeziumCustomCodec.class)
    public Uni<Void> onExportedEvent(Object incomingevent) {
        ExportedEvent event = (ExportedEvent)incomingevent;
        LOGGER.debug("An exported event was found for type {}" + event.getType());
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(OPERATION_NAME);
        DebeziumTextMap exportedSpanData = new DebeziumTextMap();
        Span parentSpan = this.tracer.activeSpan();
        if (parentSpan != null) {
            spanBuilder.asChildOf(parentSpan);
        }
        spanBuilder.withTag("aggregateType", event.getAggregateType()).withTag("aggregateId", event.getAggregateId().toString()).withTag("type", event.getAggregateType()).withTag("timestamp", event.getTimestamp().toString());
        Span activeSpan = spanBuilder.start();
        try {
            Uni<Void> uni;
            block10: {
                Scope outboxSpanScope = this.tracer.scopeManager().activate(activeSpan);
                try {
                    Tags.COMPONENT.set(activeSpan, TRACING_COMPONENT);
                    this.tracer.inject(activeSpan.context(), Format.Builtin.TEXT_MAP, (Object)exportedSpanData);
                    Map dataMap = this.getDataMapFromEvent(event);
                    dataMap.put("tracingspancontext", exportedSpanData.export());
                    uni = this.persist((Map<String, Object>)dataMap);
                    if (outboxSpanScope == null) break block10;
                }
                catch (Throwable throwable) {
                    if (outboxSpanScope != null) {
                        try {
                            outboxSpanScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outboxSpanScope.close();
            }
            return uni;
        }
        finally {
            activeSpan.finish();
        }
    }
}

