/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.reactive.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.internal.AbstractEventWriter;
import io.debezium.outbox.reactive.quarkus.internal.DebeziumOutboxRuntimeConfig;
import io.debezium.outbox.reactive.quarkus.internal.EventDispatcher;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import javax.inject.Inject;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventDispatcher
extends AbstractEventWriter<Uni<Void>>
implements EventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventDispatcher.class);
    @Inject
    Mutiny.SessionFactory factory;
    @Inject
    DebeziumOutboxRuntimeConfig config;

    protected Uni<Void> persist(Map<String, Object> dataMap) {
        return this.factory.withSession(session -> session.withTransaction(tx -> session.persist((Object)dataMap))).invoke(() -> LOGGER.debug("outbox event persisted")).call(() -> this.removeFromOutbox(dataMap));
    }

    protected Uni<Integer> removeFromOutbox(Map<String, Object> dataMap) {
        if (this.config.removeAfterInsert) {
            LOGGER.debug("removing outbox event");
            return this.factory.withSession(session -> session.withTransaction(tx -> session.createQuery("delete from io.debezium.outbox.quarkus.internal.OutboxEvent where aggregateId=:aggregateId").setParameter("aggregateId", dataMap.get("aggregateId")).executeUpdate()));
        }
        return Uni.createFrom().item((Object)-1);
    }

    protected Map<String, Object> createDataMap(ExportedEvent<?, ?> event) {
        Map dataMap = super.createDataMap(event);
        dataMap.put("$type$", "io.debezium.outbox.quarkus.internal.OutboxEvent");
        return dataMap;
    }
}

